/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.compatibility.candb.ChiselAndBitsCheck;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return true;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        if (world.func_180495_p(pos).equals(blockState)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!world.func_180501_a(pos, blockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (tileEntityData != null) {
            try {
                PlacementHandlers.handleTileEntityPlacement((CompoundNBT)tileEntityData, (World)world, (BlockPos)pos, (PlacementSettings)settings);
                blockState.func_177230_c().func_180633_a(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState((BlockState)blockState));
            }
            catch (Exception ex) {
                Log.getLogger().warn("Unable to place TileEntity");
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (!ChiselAndBitsCheck.isChiselAndBitsBlock(blockState)) {
            itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        }
        if (tileEntityData != null) {
            itemList.addAll(ItemStackUtils.getItemStacksOfTileEntity((CompoundNBT)tileEntityData, (World)world));
        }
        itemList.removeIf(ItemStackUtils::isEmpty);
        return itemList;
    }
}

