/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.ldtteam.structures.helpers.Settings;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.Log;
import com.minecolonies.apiimp.ClientMinecoloniesAPIImpl;
import com.minecolonies.coremod.client.gui.WindowBannerRallyGuards;
import com.minecolonies.coremod.client.gui.WindowClipBoard;
import com.minecolonies.coremod.client.gui.WindowDecorationController;
import com.minecolonies.coremod.client.gui.WindowInteraction;
import com.minecolonies.coremod.client.gui.WindowMinecoloniesBuildTool;
import com.minecolonies.coremod.client.gui.WindowResourceList;
import com.minecolonies.coremod.client.gui.WindowSuggestBuildTool;
import com.minecolonies.coremod.proxy.CommonProxy;
import java.io.File;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        apiImpl = new ClientMinecoloniesAPIImpl();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void showCitizenWindow(ICitizenDataView citizen) {
        WindowInteraction window = new WindowInteraction(citizen);
        window.open();
    }

    @Override
    public void openBuildToolWindow(@Nullable BlockPos pos) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        WindowMinecoloniesBuildTool window = new WindowMinecoloniesBuildTool(pos);
        window.open();
    }

    @Override
    public void openDecorationControllerWindow(@Nullable BlockPos pos) {
        if (pos == null) {
            return;
        }
        WindowDecorationController window = new WindowDecorationController(pos);
        window.open();
    }

    @Override
    public World getWorld(int dimension) {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void openSuggestionWindow(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack) {
        new WindowSuggestBuildTool(pos, state, stack).open();
    }

    @Override
    public void openBuildToolWindow(BlockPos pos, String structureName, int rotation) {
        if (pos == null && Settings.instance.getActiveStructure() == null) {
            return;
        }
        WindowMinecoloniesBuildTool window = new WindowMinecoloniesBuildTool(pos, structureName, rotation);
        window.open();
    }

    @Override
    public void openBannerRallyGuardsWindow(ItemStack banner) {
        WindowBannerRallyGuards window = new WindowBannerRallyGuards(banner);
        window.open();
    }

    @Override
    public void openClipBoardWindow(IColonyView colonyView) {
        WindowClipBoard window = new WindowClipBoard(colonyView);
        window.open();
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos buildingPos) {
        WindowResourceList window = new WindowResourceList(colonyId, buildingPos);
        window.open();
    }

    @Override
    public File getSchematicsFolder() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            if (IColonyManager.getInstance().getServerUUID() != null) {
                return new File(Minecraft.func_71410_x().field_71412_D, "minecolonies/" + IColonyManager.getInstance().getServerUUID());
            }
            Log.getLogger().error("ColonyManager.getServerUUID() => null this should not happen", (Throwable)new Exception());
            return null;
        }
        File worldSchematicFolder = new File(ServerLifecycleHooks.getCurrentServer().func_71238_n() + "/" + "minecolonies" + '/' + "schematics");
        if (!worldSchematicFolder.exists()) {
            return new File(Minecraft.func_71410_x().field_71412_D, "minecolonies");
        }
        return worldSchematicFolder.getParentFile();
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull PlayerEntity player) {
        if (player instanceof ClientPlayerEntity) {
            return ((ClientPlayerEntity)player).func_199507_B();
        }
        return super.getRecipeBookFromPlayer(player);
    }
}

