/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.factories.IGlobalResearchFactory;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.research.GlobalResearch;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchFactory
implements IGlobalResearchFactory {
    @Override
    @NotNull
    public TypeToken<GlobalResearch> getFactoryOutputType() {
        return TypeToken.of(GlobalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public IGlobalResearch getNewInstance(String id, String parent, String branch, @NotNull String desc, int depth, IResearchEffect<?> effect) {
        return new GlobalResearch(id, branch, desc, depth, effect);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull IGlobalResearch effect) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("parent", effect.getParent());
        compound.func_74778_a("id", effect.getId());
        compound.func_74778_a("branch", effect.getBranch());
        compound.func_74778_a("desc", effect.getDesc());
        compound.func_218657_a("effect", (INBT)StandardFactoryController.getInstance().serialize(effect));
        compound.func_74768_a("depth", effect.getDepth());
        compound.func_74757_a("onlyChild", effect.hasOnlyChild());
        ListNBT childTagList = effect.getChilds().stream().map(child -> {
            CompoundNBT childCompound = new CompoundNBT();
            childCompound.func_74778_a("child", child);
            return childCompound;
        }).collect(NBTUtils.toListNBT());
        compound.func_218657_a("hasResearchedChild", (INBT)childTagList);
        return compound;
    }

    @Override
    @NotNull
    public IGlobalResearch deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        String parent = nbt.func_74779_i("parent");
        String id = nbt.func_74779_i("id");
        String branch = nbt.func_74779_i("branch");
        String desc = nbt.func_74779_i("desc");
        CompoundNBT effect = nbt.func_74775_l("effect");
        int depth = nbt.func_74762_e("depth");
        boolean onlyChild = nbt.func_74767_n("onlyChild");
        IGlobalResearch research = this.getNewInstance(id, parent, branch, desc, depth, (IResearchEffect)StandardFactoryController.getInstance().deserialize(effect));
        research.loadCostFromConfig();
        research.setOnlyChild(onlyChild);
        NBTUtils.streamCompound(nbt.func_150295_c("hasResearchedChild", 10)).forEach(compound -> IGlobalResearchTree.getInstance().getResearch(branch, compound.func_74779_i("child")));
        return research;
    }

    @Override
    public void serialize(IFactoryController controller, IGlobalResearch input, PacketBuffer packetBuffer) {
        packetBuffer.func_180714_a(input.getParent());
        packetBuffer.func_180714_a(input.getId());
        packetBuffer.func_180714_a(input.getBranch());
        packetBuffer.func_180714_a(input.getDesc());
        controller.serialize(packetBuffer, input);
        packetBuffer.writeInt(input.getDepth());
        packetBuffer.writeBoolean(input.hasOnlyChild());
        packetBuffer.writeInt(input.getChilds().size());
        input.getChilds().forEach(child -> packetBuffer.func_180714_a(child));
    }

    @Override
    public IGlobalResearch deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        String parent = buffer.func_218666_n();
        String id = buffer.func_218666_n();
        String branch = buffer.func_218666_n();
        String desc = buffer.func_218666_n();
        IResearchEffect effect = (IResearchEffect)controller.deserialize(buffer);
        int depth = buffer.readInt();
        boolean onlyChild = buffer.readBoolean();
        IGlobalResearch research = this.getNewInstance(id, parent, branch, desc, depth, effect);
        research.loadCostFromConfig();
        research.setOnlyChild(onlyChild);
        int childsSize = buffer.readInt();
        for (int i = 0; i < childsSize; ++i) {
            IGlobalResearchTree.getInstance().getResearch(branch, buffer.func_218666_n());
        }
        return research;
    }

    @Override
    public short getSerializationId() {
        return 28;
    }
}

