/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;

public class LocalResearch
implements ILocalResearch {
    private final int depth;
    private ResearchState state;
    private final String id;
    private final String branch;
    private int progress;

    public LocalResearch(String id, String branch, int depth) {
        this.id = id;
        this.depth = depth;
        this.branch = branch;
    }

    @Override
    public boolean research(IResearchEffectManager effects, ILocalResearchTree tree) {
        if (this.state == ResearchState.IN_PROGRESS) {
            ++this.progress;
            if ((double)this.progress >= 144.0 * Math.pow(2.0, this.depth - 1)) {
                this.state = ResearchState.FINISHED;
                effects.applyEffect(IGlobalResearchTree.getInstance().getResearch(this.branch, this.getId()).getEffect());
                tree.finishResearch(this.id);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ResearchState getState() {
        return this.state;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setState(ResearchState value) {
        this.state = value;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }
}

