/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResearchEffectManager
implements IResearchEffectManager {
    private final Map<String, IResearchEffect<?>> effectMap = new HashMap();

    @Override
    public <W extends IResearchEffect<?>> W getEffect(String id, @NotNull Class<W> type) {
        IResearchEffect<?> effect = this.effectMap.get(id);
        if (type.isInstance(effect)) {
            return (W)effect;
        }
        return null;
    }

    @Override
    public void applyEffect(IResearchEffect<?> effect) {
        if (this.effectMap.containsKey(effect.getId())) {
            IResearchEffect<?> effectInMap = this.effectMap.get(effect.getId());
            if (effect.overrides(effectInMap)) {
                this.effectMap.put(effect.getId(), effect);
            }
        } else {
            this.effectMap.put(effect.getId(), effect);
        }
    }
}

