/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.WorldUtil;
import java.util.Random;
import net.minecraft.block.AirBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;

public class TileEntityCompostedDirt
extends TileEntity
implements ITickableTileEntity {
    private boolean composted = false;
    private int ticker = 0;
    private double percentage = 1.0;
    private static final int TICKER_LIMIT = 300;
    private final Random random = new Random();
    private ItemStack flower;

    public TileEntityCompostedDirt() {
        super(MinecoloniesTileEntities.COMPOSTED_DIRT);
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (!world.field_72995_K && this.composted && this.ticker % 20 == 0) {
            this.updateTick(world);
        }
        ++this.ticker;
    }

    private void updateTick(@NotNull World worldIn) {
        BlockPos position;
        if (this.flower == null || this.flower.func_190926_b()) {
            this.composted = false;
            return;
        }
        if (this.composted) {
            ((ServerWorld)worldIn).func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0);
        }
        if (this.random.nextDouble() * 100.0 <= this.percentage && worldIn.func_180495_p(position = this.field_174879_c.func_177984_a()).func_177230_c() instanceof AirBlock) {
            if (this.flower.func_77973_b() instanceof BlockItem) {
                if (((BlockItem)this.flower.func_77973_b()).func_179223_d() instanceof DoublePlantBlock) {
                    ((DoublePlantBlock)((BlockItem)this.flower.func_77973_b()).func_179223_d()).func_196390_a((IWorld)worldIn, position, 3);
                } else {
                    worldIn.func_175656_a(position, ((BlockItem)this.flower.func_77973_b()).func_179223_d().func_176223_P());
                }
            } else {
                worldIn.func_175656_a(position, BlockUtils.getBlockStateFromStack((ItemStack)this.flower));
            }
        }
        if (this.ticker >= 6000) {
            this.ticker = 0;
            this.composted = false;
        }
    }

    public void func_70296_d() {
        WorldUtil.markChunkDirty(this.field_145850_b, this.field_174879_c);
    }

    public void compost(double percentage, @NotNull ItemStack flower) {
        if (percentage >= 0.0 && percentage <= 100.0) {
            this.percentage = percentage;
            try {
                this.flower = flower;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.composted = true;
    }

    public boolean isComposted() {
        return this.composted;
    }
}

