/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.google.common.io.Files;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.util.ChunkDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private static final int MAX_COLONY_LOAD = 5000;

    private BackUpHelper() {
    }

    public static boolean backupColonyData() {
        BackUpHelper.saveColonies();
        try (FileOutputStream fos = new FileOutputStream(BackUpHelper.getBackupSaveLocation(new Date()));){
            File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
            ZipOutputStream zos = new ZipOutputStream(fos);
            DimensionType.func_212681_b().forEach(dimensionType -> {
                for (int i = 1; i <= IColonyManager.getInstance().getTopColonyId() + 1; ++i) {
                    File file = new File(saveDir, String.format("colony%d_%d.dat", i, dimensionType.func_186068_a()));
                    File fileDeleted = new File(saveDir, String.format("colony%d_%d.dat.deleted", i, dimensionType.func_186068_a()));
                    if (file.exists()) {
                        if (IColonyManager.getInstance().getColonyByDimension(i, dimensionType.func_186068_a()) == null) {
                            BackUpHelper.markColonyDeleted(i, dimensionType.func_186068_a());
                            BackUpHelper.addToZipFile(String.format("colony%d_%d.dat.deleted", i, dimensionType.func_186068_a()), zos, saveDir);
                            continue;
                        }
                        BackUpHelper.addToZipFile(String.format("colony%d_%d.dat", i, dimensionType.func_186068_a()), zos, saveDir);
                        continue;
                    }
                    if (!fileDeleted.exists()) continue;
                    BackUpHelper.addToZipFile(String.format("colony%d_%d.dat.deleted", i, dimensionType.func_186068_a()), zos, saveDir);
                }
            });
            BackUpHelper.addToZipFile(BackUpHelper.getSaveLocation().getName(), zos, saveDir);
            zos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void loadMissingColonies() {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        DimensionType.func_212681_b().forEach(dimensionType -> {
            int missingFilesInRow = 0;
            for (int i = 1; i <= 5000 && missingFilesInRow < 5; ++i) {
                File file = new File(saveDir, String.format("colony%d_%d.dat", i, dimensionType.func_186068_a()));
                if (file.exists()) {
                    missingFilesInRow = 0;
                    if (IColonyManager.getInstance().getColonyByDimension(i, dimensionType.func_186068_a()) != null) continue;
                    BackUpHelper.loadColonyBackup(i, dimensionType.func_186068_a(), false, false);
                    continue;
                }
                ++missingFilesInRow;
            }
        });
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        return new File(saveDir, String.format("colonies-%s.zip", new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    private static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(fileName));
            Files.copy((File)file, (OutputStream)zos);
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + fileName + " into the zip.", (Throwable)e);
        }
    }

    @NotNull
    public static File getSaveLocation() {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        return new File(saveDir, "colonies.dat");
    }

    @NotNull
    public static File getSaveLocation(ServerWorld world) {
        File saveDir = new File(world.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        return new File(saveDir, "colonies.dat");
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull CompoundNBT compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((CompoundNBT)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static CompoundNBT loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading file from path in ColonyManager!", (Throwable)exception);
        }
        return null;
    }

    public static void saveColonies() {
        CompoundNBT compound = new CompoundNBT();
        IColonyManager.getInstance().write(compound);
        File file = BackUpHelper.getSaveLocation();
        BackUpHelper.saveNBTToPath(file, compound);
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
            CompoundNBT colonyCompound = new CompoundNBT();
            colony.write(colonyCompound);
            BackUpHelper.saveNBTToPath(new File(saveDir, String.format("colony%d_%d.dat", colony.getID(), colony.getDimension())), colonyCompound);
        }
    }

    public static void markColonyDeleted(int colonyID, int dimensionID) {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        File todelete = new File(saveDir, String.format("colony%d_%d.dat", colonyID, dimensionID));
        if (todelete.exists()) {
            new File(saveDir, String.format("colony%d_%d.dat.deleted", colonyID, dimensionID)).delete();
            todelete.renameTo(new File(saveDir, String.format("colony%d_%d.dat.deleted", colonyID, dimensionID)));
        }
    }

    public static void loadAllBackups() {
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        DimensionType.func_212681_b().forEach(dimensionType -> {
            for (int i = 1; i <= IColonyManager.getInstance().getTopColonyId() + 1; ++i) {
                File file = new File(saveDir, String.format("colony%d_%d.dat", i, dimensionType.func_186068_a()));
                if (!file.exists()) continue;
                BackUpHelper.loadColonyBackup(i, dimensionType.func_186068_a(), false, false);
            }
        });
    }

    public static void loadColonyBackup(int colonyId, int dimension, boolean loadDeleted, boolean claimChunks) {
        IColony colony;
        File saveDir = new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), "minecolonies");
        CompoundNBT compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d_%d.dat", colonyId, dimension)));
        if (compound == null) {
            if (loadDeleted) {
                compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d_%d.dat.deleted", colonyId, dimension)));
            }
            if (compound == null) {
                Log.getLogger().warn("Can't find NBT of colony: " + colonyId + " at location: " + new File(saveDir, String.format("colony%d_%d.dat", colonyId, dimension)));
                return;
            }
        }
        if ((colony = IColonyManager.getInstance().getColonyByDimension(colonyId, dimension)) != null) {
            colony.read(compound);
        } else {
            IColonyTagCapability cap;
            Log.getLogger().warn("Colony:" + colonyId + " is missing, loading backup!");
            ServerWorld colonyWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.func_186069_a((int)dimension));
            colony = Colony.loadColony(compound, (World)colonyWorld);
            if (colony == null) {
                Log.getLogger().warn("Colony:" + colonyId + " loadBackup failed!");
                return;
            }
            ((IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElse(null)).addColony(colony);
            if (claimChunks && (cap = (IColonyTagCapability)((Chunk)colonyWorld.func_217349_x(colony.getCenter())).getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElse(null)) != null && cap.getOwningColony() != colonyId) {
                for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                    ChunkDataHelper.claimColonyChunks(colony, true, building.getPosition(), building.getClaimRadius(building.getBuildingLevel()));
                }
                ChunkDataHelper.claimColonyChunks((World)colonyWorld, true, colony.getID(), colony.getCenter(), colony.getDimension());
            }
        }
        Log.getLogger().warn("Successfully restored colony:" + colonyId);
    }
}

