/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class BuildingUtils {
    private BuildingUtils() {
    }

    public static AxisAlignedBB getTargetAbleArea(World world, AbstractSchematicProvider building) {
        int y2;
        int z2;
        int x2;
        int z1;
        int x1;
        BlockPos location = building.getPosition();
        int y1 = location.func_177956_o() - 10;
        if (building.getHeight() == 0) {
            StructureName sn = new StructureName("schematics", building.getStyle(), building.getSchematicName() + building.getBuildingLevel());
            String structureName = sn.toString();
            LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(world, building.getID(), structureName, new PlacementSettings(), true);
            wrapper.getBluePrint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(building.getRotation()), building.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, world);
            BlockPos zeroPos = location.func_177973_b((Vec3i)wrapper.getBluePrint().getPrimaryBlockOffset());
            x1 = zeroPos.func_177958_n();
            z1 = zeroPos.func_177952_p();
            x2 = zeroPos.func_177958_n() + wrapper.getBluePrint().getSizeX();
            z2 = zeroPos.func_177952_p() + wrapper.getBluePrint().getSizeZ();
            y2 = location.func_177956_o() + wrapper.getBluePrint().getSizeY();
            building.setCorners(x1, x2, z1, z2);
            building.setHeight(wrapper.getBluePrint().getSizeY());
        } else {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = building.getCorners();
            x1 = (Integer)((Tuple)corners.func_76341_a()).func_76341_a();
            x2 = (Integer)((Tuple)corners.func_76341_a()).func_76340_b();
            z1 = (Integer)((Tuple)corners.func_76340_b()).func_76341_a();
            z2 = (Integer)((Tuple)corners.func_76340_b()).func_76340_b();
            y2 = location.func_177956_o() + building.getHeight();
        }
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static ItemStack getItemStackForHutFromInventory(PlayerInventory inventory, String hut) {
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)inventory.field_70458_d, item -> item.func_77973_b() instanceof BlockItem && ((BlockItem)item.func_77973_b()).func_179223_d() instanceof AbstractBlockHut && ((BlockItem)item.func_77973_b()).func_179223_d().getRegistryName().func_110623_a().endsWith(hut));
        if (slot != -1) {
            return inventory.func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }
}

