/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.util.BackUpHelper;
import java.io.File;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public final class ChunkDataHelper {
    private static final int DISTANCE_TO_DELETE = (Integer)MineColonies.getConfig().getCommon().maxColonySize.get() * 16 * 2 * 5;

    private ChunkDataHelper() {
    }

    public static void loadChunk(Chunk chunk, World world) {
        IColony colony;
        IColonyTagCapability closeCap;
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElseGet(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        if (!chunkManager.getAllChunkStorages().isEmpty()) {
            IColonyTagCapability closeCap2;
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null).orElseGet(null);
            if (cap == null) {
                return;
            }
            ChunkLoadStorage existingStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
            if (existingStorage != null) {
                ChunkDataHelper.addStorageToChunk(chunk, existingStorage);
            } else if (((Boolean)MineColonies.getConfig().getCommon().fixOrphanedChunks.get()).booleanValue() && (closeCap2 = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)) != null) {
                boolean dirty = false;
                for (int colony2 : closeCap2.getAllCloseColonies()) {
                    if (colony2 == 0 || cap.getColony(colony2) != null && BlockPosUtil.getDistance2D(cap.getColony(colony2).getCenter(), new BlockPos(chunk.func_76632_l().field_77276_a * 16, 0, chunk.func_76632_l().field_77275_b * 16)) <= (long)DISTANCE_TO_DELETE) continue;
                    Log.getLogger().warn("Removing orphaned chunk at:  " + chunk.func_76632_l().field_77276_a * 16 + " 100 " + chunk.func_76632_l().field_77275_b * 16);
                    closeCap2.removeColony(colony2, chunk);
                    dirty = true;
                }
                if (dirty) {
                    Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(closeCap2, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
                }
            }
        }
        if ((closeCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)) != null && closeCap.getOwningColony() != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeCap.getOwningColony(), world.func_201675_m().func_186058_p().func_186068_a())) != null) {
            colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b));
        }
    }

    public static void unloadChunk(Chunk chunk, World world) {
        IColony colony;
        IColonyTagCapability closeCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (closeCap != null && closeCap.getOwningColony() != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeCap.getOwningColony(), world.func_201675_m().func_186058_p().func_186068_a())) != null) {
            colony.removeLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b));
        }
    }

    public static void addStorageToChunk(Chunk chunk, ChunkLoadStorage storage) {
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        storage.applyToCap(cap, chunk);
        if (cap != null) {
            Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        }
    }

    public static void loadChunkStorageToWorldCapability(World world) {
        File chunkDir = new File(((ServerWorld)world).func_217485_w().func_75765_b(), "minecolonies/chunkInfo");
        if (!chunkDir.exists()) {
            return;
        }
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElseGet(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        File[] files = chunkDir.listFiles();
        if (files != null) {
            for (File file : files) {
                CompoundNBT chunkData = BackUpHelper.loadNBTFromPath(file);
                if (chunkData == null) continue;
                ChunkLoadStorage storage = new ChunkLoadStorage(chunkData);
                int z = (int)(storage.getXz() >> 32);
                int x = (int)storage.getXz();
                chunkManager.addChunkStorage(x, z, storage);
                file.delete();
            }
        }
    }

    public static void claimColonyChunks(World world, boolean add, int id, BlockPos center, int dimension) {
        int range = (Integer)MineColonies.getConfig().getCommon().initialColonySize.get();
        int buffer = (Integer)MineColonies.getConfig().getCommon().minColonyDistance.get();
        ChunkDataHelper.claimChunksInRange(id, dimension, add, center, range, buffer, world);
    }

    public static void claimColonyChunks(IColony colony, boolean add, BlockPos center, int range) {
        ChunkDataHelper.claimChunksInRange(colony, add, range, center, false);
    }

    public static boolean canClaimChunksInRange(World w, BlockPos pos, int range) {
        IChunkmanagerCapability worldCapability = (IChunkmanagerCapability)w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElseGet(null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        int chunkX = centralChunk.func_76632_l().field_77276_a;
        int chunkZ = centralChunk.func_76632_l().field_77275_b;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                Chunk chunk = w.func_212866_a_(i, j);
                IColonyTagCapability colonyCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (colonyCap == null) {
                    return false;
                }
                ChunkLoadStorage storage = worldCapability.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
                if (storage != null) {
                    storage.applyToCap(colonyCap, chunk);
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static void claimChunksInRange(IColony colony, boolean add, int range, BlockPos center, boolean force) {
        World world = colony.getWorld();
        int colonyId = colony.getID();
        int dimension = colony.getDimension();
        boolean areAllChunksAdded = true;
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElseGet(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int chunkColonyCenterX = colony.getCenter().func_177958_n() >> 4;
        int chunkColonyCenterZ = colony.getCenter().func_177952_p() >> 4;
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().func_177958_n(), 0, colony.getCenter().func_177952_p());
        int chunkX = center.func_177958_n() >> 4;
        int chunkZ = center.func_177952_p() >> 4;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                if (!force && !add && Math.abs(chunkColonyCenterX - i) <= (Integer)MineColonies.getConfig().getCommon().initialColonySize.get() + 1 && Math.abs(chunkColonyCenterZ - j) <= (Integer)MineColonies.getConfig().getCommon().initialColonySize.get() + 1) {
                    Log.getLogger().debug("Unclaim of initial chunk prevented");
                    continue;
                }
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                if (!force && (Integer)MineColonies.getConfig().getCommon().maxColonySize.get() != 0 && pos.func_177951_i((Vec3i)colonyCenterCompare) > Math.pow((Integer)MineColonies.getConfig().getCommon().maxColonySize.get() * 16, 2.0)) {
                    Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.func_177958_n() + " Z:" + pos.func_177952_p() + " too far away from the colony:" + colony.getID() + " center:" + colony.getCenter() + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (ChunkDataHelper.loadChunkAndAddData(world, pos, add, colonyId, center, chunkManager)) continue;
                areAllChunksAdded = false;
                ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), dimension, center);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
        if (areAllChunksAdded && add && range > 0) {
            IBuilding building = colony.getBuildingManager().getBuilding(center);
            LanguageHandler.sendPlayersMessage(colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.colonysizechange", (Object[])new Object[]{range, building.getSchematicName()});
        }
    }

    public static void claimChunksInRange(int colonyId, int dimension, boolean add, BlockPos center, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElseGet(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        Chunk centralChunk = world.func_175726_f(center);
        ChunkDataHelper.loadChunkAndAddData(world, center, add, colonyId, chunkManager);
        int chunkX = centralChunk.func_76632_l().field_77276_a;
        int chunkZ = centralChunk.func_76632_l().field_77275_b;
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                if (i == chunkX && j == chunkZ || i >= chunkX - 5 && j >= chunkZ - 5 && i <= chunkX + 5 && j <= chunkZ + 5 && ChunkDataHelper.loadChunkAndAddData(world, new BlockPos(i * 16, 0, j * 16), add, colonyId, chunkManager)) continue;
                boolean owning = i >= chunkX - range && j >= chunkZ - range && i <= chunkX + range && j <= chunkZ + range;
                ChunkLoadStorage newStorage = new ChunkLoadStorage(colonyId, ChunkPos.func_77272_a((int)i, (int)j), add, dimension, owning);
                chunkManager.addChunkStorage(i, j, newStorage);
            }
        }
    }

    public static void debugChunksInRange(int chunkX, int chunkZ, int range, int buffer, World world) {
        IChunkmanagerCapability chunkManager = (IChunkmanagerCapability)world.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).orElseGet(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return;
        }
        int maxRange = range * 2 + buffer;
        for (int i = chunkX - maxRange; i <= chunkX + maxRange; ++i) {
            for (int j = chunkZ - maxRange; j <= chunkZ + maxRange; ++j) {
                BlockPos pos = new BlockPos(i * 16, 0, j * 16);
                Chunk chunk = world.func_175726_f(pos);
                if (((IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)).getOwningColony() == 0) continue;
                Log.getLogger().warn("Has owner: " + pos.toString());
            }
        }
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) {
            return false;
        }
        Chunk chunk = (Chunk)world.func_217349_x(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (cap.getOwningColony() == id && add) {
            return true;
        }
        if (add) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(id, world.func_201675_m().func_186058_p().func_186068_a());
            if (colony != null) {
                colony.addLoadedChunk(ChunkPos.func_77272_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b));
            }
            cap.setOwningColony(id, chunk);
            cap.addColony(id, chunk);
        } else {
            cap.removeColony(id, chunk);
        }
        Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        return true;
    }

    public static boolean loadChunkAndAddData(World world, BlockPos pos, boolean add, int id, BlockPos buildingPos, IChunkmanagerCapability chunkManager) {
        if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap == null) {
            return false;
        }
        ChunkLoadStorage chunkLoadStorage = chunkManager.getChunkStorage(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        if (chunkLoadStorage != null) {
            chunkLoadStorage.applyToCap(cap, chunk);
        }
        if (add) {
            cap.addBuildingClaim(id, buildingPos, chunk);
        } else {
            cap.removeBuildingClaim(id, buildingPos, chunk);
        }
        Network.getNetwork().sendToEveryone(new UpdateChunkCapabilityMessage(cap, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b));
        return true;
    }
}

