/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.config.types;

import com.davenonymous.libnonymous.gui.config.types.SettingListEntry;
import com.davenonymous.libnonymous.gui.framework.ColorHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetFontAwesome;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetInputField;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;

public class DoubleSettingListEntry
extends SettingListEntry {
    WidgetInputField inputField;

    public DoubleSettingListEntry(String optionKey, String comment, ForgeConfigSpec.ConfigValue value, Object defaultValue, int columnWidth) {
        super(optionKey, comment, value, defaultValue, columnWidth);
    }

    @Override
    public void fillPanel(int entryHeight) {
        double val = (Double)this.value.get();
        this.setSize(this.columnWidth, entryHeight + 18);
        this.inputField = new WidgetInputField();
        this.inputField.setValue(String.format("%.4f", val));
        this.inputField.setDimensions(5, entryHeight - 3, this.columnWidth - 26, 14);
        this.add(this.inputField);
        WidgetFontAwesome saveButton = new WidgetFontAwesome(SAVE_ICON, WidgetFontAwesome.IconSize.MEDIUM);
        saveButton.setColor(ColorHelper.COLOR_DISABLED);
        saveButton.setPosition(this.columnWidth - 16, entryHeight - 4);
        saveButton.addListener(MouseEnterEvent.class, (event, widget) -> {
            saveButton.setColor(ColorHelper.COLOR_ENABLED);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        saveButton.addListener(MouseExitEvent.class, (event, widget) -> {
            saveButton.setColor(ColorHelper.COLOR_DISABLED);
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        saveButton.addListener(MouseClickEvent.class, (event, widget) -> {
            String inputText = this.inputField.getText();
            double inputVal = 0.0;
            try {
                inputVal = Double.parseDouble(inputText);
                this.value.set((Object)inputVal);
                this.value.save();
                this.updateDefaultIconState();
                this.hideErrorIcon();
            }
            catch (NumberFormatException e) {
                this.showErrorIcon(I18n.func_135052_a((String)"libnonymous.config.error.invalid_decimal", (Object[])new Object[0]));
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.add(saveButton);
    }

    @Override
    public void setValueInInputField(Object defaultValue) {
        if (defaultValue == null) {
            this.inputField.setValue("");
        } else {
            this.inputField.setValue(String.format("%.4f", defaultValue));
        }
    }
}

