/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.event.CharTypedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyPressedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithValue;
import com.google.common.base.Predicates;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;

public class WidgetInputField
extends WidgetWithValue<String> {
    private boolean hasShiftKeyDown;
    private int cursorPosition;
    private int lineScrollOffset;
    private int selectionEnd;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private int maxStringLength = 128;
    private String suggestion;
    private int cursorCounter;
    private Predicate<String> validator = Predicates.alwaysTrue();
    private final FontRenderer fontRenderer;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;

    public WidgetInputField() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.lineScrollOffset = 0;
        this.value = "";
        this.addListener(KeyPressedEvent.class, (event, widget) -> {
            boolean result = this.onKeyPressed(event.keyCode, event.scanCode, event.modifiers);
            return !result ? WidgetEventResult.CONTINUE_PROCESSING : WidgetEventResult.HANDLED;
        });
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            boolean result = this.mouseClicked(event.x, event.y, event.button);
            return !result ? WidgetEventResult.CONTINUE_PROCESSING : WidgetEventResult.HANDLED;
        });
        this.addListener(CharTypedEvent.class, (event, widget) -> {
            boolean result = this.charTyped(event.chr, event.scanCode);
            return !result ? WidgetEventResult.CONTINUE_PROCESSING : WidgetEventResult.HANDLED;
        });
    }

    public WidgetInputField setValidator(Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public WidgetInputField setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        return this;
    }

    public boolean charTyped(char chr, int scanCode) {
        if (!this.isFocused()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)chr)) {
            if (this.enabled) {
                this.writeText(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(Screen screen) {
        super.draw(screen);
        int renderX = 0;
        int renderY = 0;
        if (this.isVisible()) {
            if (this.enableBackgroundDrawing) {
                AbstractGui.fill((int)(renderX - 1), (int)(renderY - 1), (int)(renderX + this.width + 1), (int)(renderY + this.height + 1), (int)-6250336);
                AbstractGui.fill((int)renderX, (int)renderY, (int)(renderX + this.width), (int)(renderY + this.height), (int)-16777216);
            }
            int i = this.enabled ? this.enabledColor : this.disabledColor;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.fontRenderer.func_78269_a(((String)this.value).substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused() && this.cursorCounter / 6 % 2 == 0 && flag;
            int l = this.enableBackgroundDrawing ? renderX + 4 : renderX;
            int i1 = this.enableBackgroundDrawing ? renderY + (this.height - 8) / 2 : renderY;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = this.fontRenderer.func_175063_a(this.textFormatter.apply(s1, this.lineScrollOffset), (float)l, (float)i1, i);
            }
            boolean flag2 = this.cursorPosition < ((String)this.value).length() || ((String)this.value).length() >= this.maxStringLength;
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                this.fontRenderer.func_175063_a(this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)j1, (float)i1, i);
            }
            if (!flag2 && this.suggestion != null) {
                this.fontRenderer.func_175063_a(this.suggestion, (float)(k1 - 1), (float)i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    AbstractGui.fill((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    this.fontRenderer.func_175063_a("_", (float)k1, (float)i1, i);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.func_78256_a(s.substring(0, k));
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public WidgetInputField setSuggestion(String suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            if (textIn.length() > this.maxStringLength) {
                this.setValue(textIn.substring(0, this.maxStringLength));
            } else {
                this.setValue(textIn);
            }
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.lineScrollOffset = 0;
        }
    }

    public String getText() {
        return (String)this.value;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return ((String)this.value).substring(i, j);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(((String)this.value).length());
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.cursorPosition + num);
    }

    public void setCursorPosition(int pos) {
        this.setClampedCursorPosition(pos);
        if (!this.hasShiftKeyDown) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setClampedCursorPosition(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)((String)this.value).length());
    }

    private boolean isFocused() {
        return this.isVisible() && this.enabled && this.focused;
    }

    private void delete(int p_212950_1_) {
        if (Screen.hasControlDown()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!((String)this.value).isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!((String)this.value).isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = num < 0;
                int i = flag ? this.cursorPosition + num : this.cursorPosition;
                int j = flag ? this.cursorPosition : this.cursorPosition + num;
                String s = "";
                if (i >= 0) {
                    s = ((String)this.value).substring(0, i);
                }
                if (j < ((String)this.value).length()) {
                    s = s + ((String)this.value).substring(j);
                }
                if (this.validator.test(s)) {
                    this.setValue(s);
                    if (flag) {
                        this.moveCursorBy(num);
                    }
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.cursorPosition);
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = ((String)this.value).length();
                if ((i = ((String)this.value).indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && ((String)this.value).charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && ((String)this.value).charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && ((String)this.value).charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = SharedConstants.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - ((String)this.value).length() - (i - j);
        if (!((String)this.value).isEmpty()) {
            s = s + ((String)this.value).substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!((String)this.value).isEmpty() && j < ((String)this.value).length()) {
            s = s + ((String)this.value).substring(j);
        }
        if (this.validator.test(s)) {
            this.setValue(s);
            this.setClampedCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
        }
    }

    private boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused()) {
            return false;
        }
        if (keyCode == 69) {
            return true;
        }
        this.hasShiftKeyDown = Screen.hasShiftDown();
        if (Screen.isSelectAll((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            if (this.enabled) {
                this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            if (this.enabled) {
                this.writeText("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.enabled) {
                    this.hasShiftKeyDown = false;
                    this.delete(-1);
                    this.hasShiftKeyDown = Screen.hasShiftDown();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.enabled) {
                    this.hasShiftKeyDown = false;
                    this.delete(1);
                    this.hasShiftKeyDown = Screen.hasShiftDown();
                }
                return true;
            }
            case 262: {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        int thisX = this.getActualX();
        int thisY = this.getActualY();
        if (!this.isFocused()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)thisX && mouseX < (double)(thisX + this.width) && mouseY >= (double)thisY && mouseY < (double)(thisY + this.height);
        if (this.canLoseFocus) {
            this.focused = flag;
        }
        if (this.isFocused() && flag && mouseButton == 0) {
            int i = MathHelper.func_76128_c((double)mouseX) - this.x;
            if (this.enableBackgroundDrawing) {
                i -= 4;
            }
            String s = this.fontRenderer.func_78269_a(((String)this.value).substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.func_78269_a(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public int getAdjustedWidth() {
        return this.enableBackgroundDrawing ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = ((String)this.value).length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.func_78269_a(((String)this.value).substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_78262_a((String)this.value, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }
}

