/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithValue;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class WidgetItemStack
extends WidgetWithValue<ItemStack> {
    boolean drawSlot = false;

    public WidgetItemStack(ItemStack stack) {
        this.setSize(16, 16);
        this.setValue(stack);
    }

    public WidgetItemStack(ItemStack stack, boolean drawSlot) {
        this(stack);
        this.drawSlot = drawSlot;
    }

    @Override
    public void setValue(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ITooltipFlag.TooltipFlags tooltipFlag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            this.setTooltipLines(stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)tooltipFlag));
        } else {
            this.setTooltipLines(Collections.emptyList());
        }
        super.setValue(stack);
    }

    @Override
    public void draw(Screen screen) {
        super.draw(screen);
        if (this.drawSlot) {
            this.drawSlot(screen);
        }
        if (this.value == null || ((ItemStack)this.value).func_190926_b()) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.disableLighting();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        double xScale = (float)this.width / 16.0f;
        double yScale = (float)this.height / 16.0f;
        RenderSystem.scaled((double)xScale, (double)yScale, (double)1.0);
        Minecraft.func_71410_x().func_175599_af().func_180450_b((ItemStack)this.value, 0, 0);
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    private void drawSlot(Screen screen) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.getMinecraft().field_71446_o.func_110577_a(GUI.tabIcons);
        int texOffsetY = 84;
        int texOffsetX = 84;
        GuiUtils.drawTexturedModalRect((int)-1, (int)-1, (int)texOffsetX, (int)texOffsetY, (int)18, (int)18, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

