/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.ISelectable;
import com.davenonymous.libnonymous.gui.framework.event.ListSelectionEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseScrollEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetTextBox;
import com.davenonymous.libnonymous.utils.Logz;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class WidgetList
extends WidgetPanel {
    public int padding = 2;
    public int scrollLines = 1;
    private int lineOffset = 0;
    private int lastVisibleLine = 0;
    private int visibleWidgets = 0;
    protected int selected = -1;
    boolean autoSelectFirstEntry = false;

    public WidgetList() {
        this.addListener(MouseScrollEvent.class, (event, widget) -> {
            if (widget.isPosInside(event.mouseX, event.mouseY)) {
                if (event.up) {
                    this.scrollUp();
                } else {
                    this.scrollDown();
                }
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public Widget getScrollUpButton(int color) {
        WidgetTextBox box = new WidgetTextBox("<"){

            @Override
            public void draw(Screen screen) {
                if (WidgetList.this.lineOffset == 0) {
                    return;
                }
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)7.0f, (float)0.0f, (float)0.0f);
                RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                super.draw(screen);
                RenderSystem.popMatrix();
            }
        };
        box.setTextColor(color);
        box.setDimensions(0, 0, 7, 6);
        box.addListener(MouseClickEvent.class, (event, widget) -> {
            this.scrollUp();
            return WidgetEventResult.HANDLED;
        });
        return box;
    }

    public Widget getScrollDownButton(int color) {
        WidgetTextBox box = new WidgetTextBox(">"){

            @Override
            public void draw(Screen screen) {
                if (WidgetList.this.lastVisibleLine == WidgetList.this.getTotalLines() - 1) {
                    return;
                }
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)7.0f, (float)0.0f, (float)0.0f);
                RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                super.draw(screen);
                RenderSystem.popMatrix();
            }
        };
        box.setTextColor(color);
        box.setDimensions(0, 0, 7, 6);
        box.addListener(MouseClickEvent.class, (event, widget) -> {
            this.scrollDown();
            return WidgetEventResult.HANDLED;
        });
        return box;
    }

    @Override
    public void clear() {
        super.clear();
        this.selected = -1;
        this.fireEvent(new ListSelectionEvent(this.selected));
    }

    public void scrollToTop() {
        this.lineOffset = 0;
    }

    public void scrollUp() {
        this.lineOffset = Math.max(0, this.lineOffset - this.scrollLines);
        this.updateWidgets();
    }

    public void scrollDown() {
        if (this.lastVisibleLine == this.getTotalLines() - 1) {
            return;
        }
        this.lineOffset += this.scrollLines;
        this.updateWidgets();
    }

    private ISelectable getSelectedWidget() {
        if (this.selected == -1) {
            return null;
        }
        return (ISelectable)this.children.get(this.selected);
    }

    public void deselect() {
        if (this.selected == -1) {
            return;
        }
        this.getSelectedWidget().setSelected(false);
        this.selected = -1;
        this.fireEvent(new ListSelectionEvent(this.selected));
    }

    public void select(int index) {
        if (index == -1) {
            this.deselect();
            return;
        }
        if (this.selected != -1) {
            this.getSelectedWidget().setSelected(false);
        }
        this.selected = index;
        this.getSelectedWidget().setSelected(true);
        this.fireEvent(new ListSelectionEvent(this.selected));
    }

    public int getTotalLines() {
        return this.children.size();
    }

    public int getLineHeight(int line) {
        if (line >= this.children.size()) {
            return 0;
        }
        return ((Widget)this.children.get((int)line)).height;
    }

    @Override
    public void draw(Screen screen) {
        int backgroundColor = -13421773;
        int borderColor = -16777216;
        int selectedBackgroundColor = -11184811;
        boolean drawScrollbar = this.visibleWidgets < this.getTotalLines();
        int scrollbarWidth = drawScrollbar ? 8 : 0;
        int listWidth = this.width - scrollbarWidth;
        GuiUtils.drawGradientRect((int)0, (int)0, (int)0, (int)listWidth, (int)this.height, (int)borderColor, (int)borderColor);
        GuiUtils.drawGradientRect((int)0, (int)1, (int)1, (int)(listWidth - 1), (int)(this.height - 1), (int)backgroundColor, (int)backgroundColor);
        if (drawScrollbar) {
            int scrollBarX = listWidth + 1;
            GuiUtils.drawGradientRect((int)0, (int)scrollBarX, (int)0, (int)(listWidth + scrollbarWidth), (int)this.height, (int)backgroundColor, (int)backgroundColor);
            int linesBefore = this.lineOffset;
            int linesAfter = this.getTotalLines() - this.lastVisibleLine - 1;
            int scrollColor = -10066330;
            float ratioBefore = (float)linesBefore / (float)this.getTotalLines();
            float ratioSize = (float)this.visibleWidgets / (float)this.getTotalLines();
            int topOffset = (int)((float)this.height * ratioBefore);
            int paddleHeight = (int)((float)this.height * ratioSize);
            if (topOffset == 0) {
                topOffset = 1;
            }
            GuiUtils.drawGradientRect((int)0, (int)(scrollBarX + 1), (int)topOffset, (int)(listWidth + scrollbarWidth - 1), (int)(topOffset + paddleHeight), (int)scrollColor, (int)scrollColor);
        }
        if (this.selected >= this.lineOffset && this.selected <= this.lastVisibleLine) {
            int yOffset = 0;
            for (int line = this.lineOffset; line < this.selected; ++line) {
                Widget widget = (Widget)this.children.get(line);
                yOffset += widget.height;
            }
            Widget selectedWidget = (Widget)this.children.get(this.selected);
            GuiUtils.drawGradientRect((int)0, (int)1, (int)(yOffset + 1), (int)(listWidth - 1), (int)(yOffset + 1 + selectedWidget.height - 1), (int)selectedBackgroundColor, (int)selectedBackgroundColor);
        }
        super.draw(screen);
    }

    public <T extends Widget> void addListEntry(T widget) {
        if (((Widget)widget).height <= 0) {
            Logz.warn("Heightless widget [%s] added to list. This will cause problems.", widget);
        }
        if (((Widget)widget).height > this.height) {
            Logz.warn("List has an entry larger than the list itself. This will cause problems.", widget);
        }
        ((Widget)widget).addListener(MouseClickEvent.class, (event, clickedWidget) -> {
            if (this.selected == this.children.indexOf(widget)) {
                this.selected = -1;
                ((ISelectable)((Object)widget)).setSelected(false);
            } else {
                Widget oldSelection;
                if (this.selected != -1 && this.selected < this.children.size() && (oldSelection = (Widget)this.children.get(this.selected)) instanceof ISelectable) {
                    ((ISelectable)((Object)oldSelection)).setSelected(false);
                }
                this.selected = this.children.indexOf(widget);
                ((ISelectable)((Object)widget)).setSelected(true);
            }
            this.fireEvent(new ListSelectionEvent(this.selected));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        super.add((Widget)widget);
        this.updateWidgets();
    }

    @Override
    public void remove(Widget widget) {
        super.remove(widget);
        this.updateWidgets();
    }

    public void updateWidgets() {
        int visibleHeight = this.padding;
        boolean exceededListHeight = false;
        this.visibleWidgets = 0;
        for (int line = 0; line < this.children.size(); ++line) {
            Widget widget = (Widget)this.children.get(line);
            if (line < this.lineOffset) {
                widget.setVisible(false);
                continue;
            }
            if (visibleHeight + widget.height > this.height - this.padding) {
                exceededListHeight = true;
            }
            if (exceededListHeight) {
                widget.setVisible(false);
                continue;
            }
            if (line == this.selected && widget instanceof ISelectable) {
                ((ISelectable)((Object)widget)).setSelected(true);
            }
            widget.setVisible(true);
            widget.setY(visibleHeight);
            widget.setX(this.padding);
            visibleHeight += widget.height;
            this.lastVisibleLine = line;
            ++this.visibleWidgets;
        }
    }
}

