/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Map;

public class WidgetTable
extends WidgetPanel {
    Table<Integer, Integer, Widget> table = TreeBasedTable.create();
    int cellPadding = 0;

    public WidgetTable setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
        return this;
    }

    public void remove(int column, int row) {
        Widget cell = (Widget)this.table.get((Object)row, (Object)column);
        if (cell == null) {
            return;
        }
        this.remove(cell);
        this.table.remove((Object)row, (Object)column);
        this.repositionCells();
    }

    public void add(int column, int row, Widget cell) {
        this.table.put((Object)row, (Object)column, (Object)cell);
        this.add(cell);
        this.repositionCells();
    }

    public int getCellHeight(int column, int row) {
        if (!this.table.contains((Object)row, (Object)column)) {
            return 0;
        }
        Widget widget = (Widget)this.table.get((Object)row, (Object)column);
        return widget.height;
    }

    public int getCellWidth(int column, int row) {
        if (!this.table.contains((Object)row, (Object)column)) {
            return 0;
        }
        Widget widget = (Widget)this.table.get((Object)row, (Object)column);
        return widget.width;
    }

    public int getColumnWidth(int column) {
        int maxWidth = 0;
        for (Widget cell : ((Map)this.table.columnMap().get(column)).values()) {
            maxWidth = Math.max(maxWidth, cell.width);
        }
        return maxWidth;
    }

    public int getRowHeight(int row) {
        int maxHeight = 0;
        for (Widget cell : ((Map)this.table.rowMap().get(row)).values()) {
            maxHeight = Math.max(maxHeight, cell.height);
        }
        return maxHeight;
    }

    public int getColumnCount() {
        return this.table.columnMap().size();
    }

    public int getRowCount() {
        return this.table.rowMap().size();
    }

    private void repositionCells() {
        int xOffset = 0;
        for (Map.Entry columnData : this.table.columnMap().entrySet()) {
            int column = (Integer)columnData.getKey();
            int columnWidth = this.getColumnWidth(column);
            int yOffset = 0;
            for (Map.Entry cellData : ((Map)columnData.getValue()).entrySet()) {
                int row = (Integer)cellData.getKey();
                int rowHeight = this.getRowHeight(row);
                Widget cell = (Widget)cellData.getValue();
                cell.setX(xOffset);
                cell.setY(yOffset);
                yOffset += rowHeight + this.cellPadding;
            }
            xOffset += columnWidth + this.cellPadding;
        }
    }
}

