/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.network;

import com.davenonymous.libnonymous.base.BasePacket;
import com.davenonymous.libnonymous.command.CommandOpenConfigGUI;
import com.davenonymous.libnonymous.network.PacketClipboard;
import com.davenonymous.libnonymous.network.PacketEnabledSlots;
import com.davenonymous.libnonymous.network.PacketOpenConfigGui;
import com.davenonymous.libnonymous.network.PacketReloadConfigs;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class Networking {
    public static SimpleChannel INSTANCE;
    private static final String CHANNEL_NAME = "channel";
    private static int ID;

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("libnonymous", CHANNEL_NAME), () -> "1.0", s -> true, s -> true);
        INSTANCE.registerMessage(Networking.nextID(), PacketClipboard.class, BasePacket::toBytes, PacketClipboard::new, BasePacket::handle);
        INSTANCE.registerMessage(Networking.nextID(), PacketEnabledSlots.class, BasePacket::toBytes, PacketEnabledSlots::new, BasePacket::handle);
        INSTANCE.registerMessage(Networking.nextID(), PacketOpenConfigGui.class, BasePacket::toBytes, PacketOpenConfigGui::new, BasePacket::handle);
        INSTANCE.registerMessage(Networking.nextID(), PacketReloadConfigs.class, BasePacket::toBytes, PacketReloadConfigs::new, BasePacket::handle);
    }

    public static void sendClipboardMessage(ServerPlayerEntity to, String clipboard) {
        INSTANCE.sendTo((Object)new PacketClipboard(clipboard), to.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendEnabledSlotsMessage(List<Slot> inventorySlots) {
        INSTANCE.sendToServer((Object)new PacketEnabledSlots(inventorySlots));
    }

    public static void openConfigGui(ServerPlayerEntity to) {
        INSTANCE.sendTo((Object)new PacketOpenConfigGui(true), to.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void openConfigGui(ServerPlayerEntity to, String modId, CommandOpenConfigGUI.Mode mode) {
        INSTANCE.sendTo((Object)new PacketOpenConfigGui(modId, mode), to.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void reloadConfigs() {
        INSTANCE.sendToServer((Object)new PacketReloadConfigs());
    }

    static {
        ID = 0;
    }
}

