/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.render;

import com.davenonymous.libnonymous.utils.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.utils.FloodFill;
import com.davenonymous.libnonymous.utils.Logz;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class MultiblockBlockModel {
    public Map<BlockPos, BlockState> blocks;
    public Map<BlockState, List<BlockPos>> reverseBlocks;
    public Map<BlockState, Character> refMap;
    public char[][][] blocksAsArray;
    public char[][][] blocksAsArray90;
    public char[][][] blocksAsArray180;
    public char[][][] blocksAsArray270;
    public ResourceLocation id;
    public int width = 0;
    public int height = 0;
    public int depth = 0;

    public MultiblockBlockModel(ResourceLocation id) {
        this.id = id;
    }

    public MultiblockBlockModel(PacketBuffer buffer) {
        this.id = buffer.func_192575_l();
        int size = buffer.readInt();
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buffer.func_179259_c();
            BlockState state = BlockStateSerializationHelper.deserializeBlockState(buffer);
            blocks.put(pos, state);
        }
        this.setBlocks(blocks);
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_192572_a(this.id);
        buffer.writeInt(this.blocks.size());
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            buffer.func_179255_a(entry.getKey());
            BlockStateSerializationHelper.serializeBlockState(buffer, entry.getValue());
        }
    }

    public void removeBlockState(BlockState state) {
        HashMap<BlockPos, BlockState> newBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            if (entry.getValue().equals(state)) continue;
            newBlocks.put(entry.getKey(), entry.getValue());
        }
        this.setBlocks(newBlocks);
    }

    public void setBlocks(Map<BlockPos, BlockState> blocks) {
        this.blocks = blocks;
        this.width = 0;
        this.height = 0;
        this.depth = 0;
        for (BlockPos pos : blocks.keySet()) {
            if (pos.func_177958_n() > this.width) {
                this.width = pos.func_177958_n();
            }
            if (pos.func_177956_o() > this.height) {
                this.height = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= this.depth) continue;
            this.depth = pos.func_177952_p();
        }
        char refChar = 'a';
        this.refMap = new HashMap<BlockState, Character>();
        this.blocksAsArray = new char[this.width + 1][this.height + 1][this.depth + 1];
        for (Map.Entry<BlockPos, BlockState> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            char c = refChar;
            refChar = (char)(refChar + 1);
            char stateChar = this.refMap.getOrDefault(state, Character.valueOf(c)).charValue();
            if (!this.refMap.containsKey(state)) {
                this.refMap.put(state, Character.valueOf(stateChar));
            }
            this.blocksAsArray[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = stateChar;
        }
        this.blocksAsArray90 = this.rotateMapCW(this.blocksAsArray);
        this.blocksAsArray180 = this.rotateMapCW(this.blocksAsArray90);
        this.blocksAsArray270 = this.rotateMapCW(this.blocksAsArray180);
        this.createReverseMap();
    }

    private void createReverseMap() {
        this.reverseBlocks = new HashMap<BlockState, List<BlockPos>>();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            if (!this.reverseBlocks.containsKey(entry.getValue())) {
                this.reverseBlocks.put(entry.getValue(), new ArrayList());
            }
            this.reverseBlocks.get(entry.getValue()).add(entry.getKey());
        }
    }

    private char[][][] rotateMapCW(char[][][] map) {
        char[][][] ret = new char[map.length][][];
        for (int y = 0; y < map.length; ++y) {
            int M = map[y].length;
            int N = map[y][0].length;
            char[][] slice = new char[N][M];
            for (int r = 0; r < M; ++r) {
                for (int c = 0; c < N; ++c) {
                    slice[c][M - 1 - r] = map[y][r][c];
                }
            }
            ret[y] = slice;
        }
        return ret;
    }

    public void setBlocksByFloodFill(IWorldReader world, BlockPos pos) {
        FloodFill floodFill = new FloodFill(world, pos);
        Map<BlockPos, BlockState> connectedBlocks = floodFill.getConnectedBlocks();
        if (connectedBlocks.size() == 0) {
            return;
        }
        this.setBlocks(connectedBlocks);
    }

    public int getBlockCount() {
        return this.blocks.keySet().size();
    }

    public Set<BlockPos> getRelevantPositions() {
        return this.blocks.keySet();
    }

    public double getScaleRatio(boolean inclHeight) {
        int dim = Math.max(this.width, this.depth);
        if (inclHeight || this.height > 10) {
            dim = Math.max(this.height, dim);
        }
        if (this.height > 6 || ++dim <= 4) {
            dim = Math.max(6, dim);
        }
        return 1.0 / (double)dim;
    }

    public String serializePretty() {
        if (this.width == 0 || this.height == 0 || this.depth == 0) {
            Logz.warn("Can not serialize model for type: '%s', invalid dimensions: w=%d, h=%d, d=%d", this.id, this.width, this.height, this.depth);
            return "";
        }
        char[][][] map = new char[this.width + 1][this.height + 1][this.depth + 1];
        StringBuilder refMapBuilder = new StringBuilder();
        refMapBuilder.append("  \"ref\": {\n");
        char nextRef = 'a';
        HashMap<String, Character> refMap = new HashMap<String, Character>();
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            char thisRef;
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            JsonObject json = BlockStateSerializationHelper.serializeBlockState(state);
            String jsonString = json.toString();
            if (refMap.containsKey(jsonString)) {
                thisRef = ((Character)refMap.get(jsonString)).charValue();
            } else {
                char c = nextRef;
                nextRef = (char)(nextRef + 1);
                thisRef = c;
                refMap.put(jsonString, Character.valueOf(thisRef));
                refMapBuilder.append("    \"" + thisRef + "\": " + jsonString + ",\n");
            }
            map[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = thisRef;
        }
        refMapBuilder.deleteCharAt(refMapBuilder.length() - 2);
        refMapBuilder.append("  },\n");
        StringBuilder output = new StringBuilder("{\n");
        output.append("  \"type\": \"" + this.id.toString() + "\",\n");
        output.append("  \"version\": 3,\n");
        output.append((CharSequence)refMapBuilder);
        output.append("  \"shape\": [\n");
        for (int x = map.length - 1; x >= 0; --x) {
            output.append("    [\n");
            for (int y = map[x].length - 1; y >= 0; --y) {
                StringBuilder builder = new StringBuilder();
                for (int z = 0; z < map[x][y].length; ++z) {
                    char chr = ' ';
                    if (map[x][y][z] != '\u0000') {
                        chr = map[x][y][z];
                    }
                    builder.append(chr);
                }
                output.append("      \"" + builder + "\",\n");
            }
            output.deleteCharAt(output.length() - 2);
            output.append("    ],\n");
        }
        output.deleteCharAt(output.length() - 2);
        output.append("  ]\n}\n");
        return output.toString();
    }

    public boolean equalsWithRotation(MultiblockBlockModel tempModel) {
        if (tempModel == this) {
            return true;
        }
        if (tempModel == null) {
            return false;
        }
        if (this.blocks.size() != tempModel.blocks.size()) {
            return false;
        }
        boolean no0 = false;
        boolean no90 = false;
        boolean no180 = false;
        boolean no270 = false;
        for (int x = 0; x < this.width; ++x) {
            block1: for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.depth; ++z) {
                    char shouldBe = this.blocksAsArray[x][y][z];
                    char at0 = tempModel.blocksAsArray[x][y][z];
                    char at90 = tempModel.blocksAsArray90[x][y][z];
                    char at180 = tempModel.blocksAsArray180[x][y][z];
                    char at270 = tempModel.blocksAsArray270[x][y][z];
                    if (at0 != shouldBe) {
                        no0 = true;
                    }
                    if (at90 != shouldBe) {
                        no90 = true;
                    }
                    if (at180 != shouldBe) {
                        no180 = true;
                    }
                    if (at270 != shouldBe) {
                        no270 = true;
                    }
                    if (no0 && no90 && no180 && no270) continue block1;
                }
            }
        }
        return no0 || no90 || no180 || no270;
    }
}

