/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.vulp.druidcraft.blocks.RopeBlock;
import com.vulp.druidcraft.blocks.tileentities.GrowthLampTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrowthLampBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty ROPED = BooleanProperty.func_177716_a((String)"roped");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public GrowthLampBlock(Block.Properties p_i49980_1_) {
        super(p_i49980_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)ROPED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GrowthLampTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape lantern_grounded = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0)), (VoxelShape)Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));
        VoxelShape lantern_hanging = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0)), (VoxelShape)Block.func_208617_a((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0));
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            if (((Boolean)state.func_177229_b((IProperty)ROPED)).booleanValue()) {
                return VoxelShapes.func_197872_a((VoxelShape)lantern_hanging, (VoxelShape)Block.func_208617_a((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
            }
            return VoxelShapes.func_197872_a((VoxelShape)lantern_hanging, (VoxelShape)Block.func_208617_a((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        }
        return VoxelShapes.func_197872_a((VoxelShape)lantern_grounded, (VoxelShape)Block.func_208617_a((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            if (direction.func_176740_k() != Direction.Axis.Y) continue;
            boolean flag = direction == Direction.UP;
            BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(flag))).func_206870_a((IProperty)ROPED, (Comparable)Boolean.valueOf(flag && context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(Direction.UP)).func_177230_c() instanceof RopeBlock));
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)blockstate.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HANGING, ROPED, WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = GrowthLampBlock.getHang(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d()) || (Boolean)state.func_177229_b((IProperty)ROPED) != false && worldIn.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c() instanceof RopeBlock;
    }

    protected static Direction getHang(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return GrowthLampBlock.getHang(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent("block.druidcraft.hold_shift", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
        } else {
            tooltip.add(new TranslationTextComponent("block.druidcraft.growth_lamp.description1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN).func_150217_b(Boolean.valueOf(true))));
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

