/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.vulp.druidcraft.blocks.RopeableLanternBlock;
import com.vulp.druidcraft.items.LunarMothJarItem;
import com.vulp.druidcraft.registry.ParticleRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LunarMothJarBlock
extends RopeableLanternBlock {
    public static IntegerProperty COLOR = IntegerProperty.func_177719_a((String)"color", (int)1, (int)6);
    public static IntegerProperty FULLNESS = IntegerProperty.func_177719_a((String)"fullness", (int)0, (int)3);

    public LunarMothJarBlock(Block.Properties properties, int mothColor) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)ROPED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)COLOR, (Comparable)Integer.valueOf(mothColor)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape lantern_grounded = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));
        VoxelShape lantern_hanging = Block.func_208617_a((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        if (((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            return VoxelShapes.func_197872_a((VoxelShape)lantern_hanging, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)14.0, (double)5.0, (double)14.0, (double)14.0, (double)11.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0)));
        }
        return lantern_grounded;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!this.isFull(state) && rand.nextInt(20) == 0) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FULLNESS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)FULLNESS) + 1)));
        }
        super.func_225542_b_(state, world, pos, rand);
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)FULLNESS) > 2;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if ((Integer)state.func_177229_b((IProperty)FULLNESS) > 0) {
            LunarMothJarBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151114_aO, ((Integer)state.func_177229_b((IProperty)FULLNESS)).intValue()));
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)FULLNESS, (Comparable)Integer.valueOf(0)), 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity entity) {
        LunarMothJarBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151114_aO, ((Integer)state.func_177229_b((IProperty)FULLNESS)).intValue()));
        super.func_176208_a(world, pos, state, entity);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HANGING, ROPED, WATERLOGGED, COLOR, FULLNESS});
    }

    public int[] colorLib(BlockState stateIn, Random rand) {
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 1) {
            if (rand.nextBoolean()) {
                return new int[]{80, 255, 155};
            }
            return new int[]{145, 255, 185};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 2) {
            if (rand.nextBoolean()) {
                return new int[]{245, 240, 220};
            }
            return new int[]{255, 255, 255};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 3) {
            if (rand.nextBoolean()) {
                return new int[]{175, 255, 105};
            }
            return new int[]{215, 255, 150};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 4) {
            if (rand.nextBoolean()) {
                return new int[]{255, 255, 150};
            }
            return new int[]{255, 255, 200};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 5) {
            if (rand.nextBoolean()) {
                return new int[]{255, 190, 75};
            }
            return new int[]{255, 220, 130};
        }
        if ((Integer)stateIn.func_177229_b((IProperty)COLOR) == 6) {
            if (rand.nextBoolean()) {
                return new int[]{255, 180, 230};
            }
            return new int[]{255, 225, 255};
        }
        return new int[]{0, 0, 0};
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.2;
        double d2 = (double)pos.func_177952_p() + 0.5;
        if (((Boolean)stateIn.func_177229_b((IProperty)HANGING)).booleanValue()) {
            d1 = (double)pos.func_177956_o() + 0.3;
        }
        int[] color = this.colorLib(stateIn, rand);
        float limit = 0.15f;
        float offset0 = Math.min(limit, Math.max(-limit, rand.nextFloat() - 0.5f));
        float offset1 = Math.min(limit, Math.max(-limit, rand.nextFloat() - 0.5f));
        float offset2 = Math.min(limit, Math.max(-limit, rand.nextFloat() - 0.5f));
        worldIn.func_195590_a((IParticleData)ParticleRegistry.magic_glitter, false, d0 + (double)offset0, d1 + (double)offset1, d2 + (double)offset2, (double)((float)color[0] / 255.0f), (double)((float)color[1] / 255.0f), (double)((float)color[2] / 255.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent("block.druidcraft.hold_shift", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
        } else {
            tooltip.add(new TranslationTextComponent("block.druidcraft.lunar_moth_lantern.description1", new Object[0]).func_150255_a(new Style().func_150238_a(this.getTextColor((LunarMothJarItem)stack.func_77973_b())).func_150217_b(Boolean.valueOf(true))));
        }
    }

    public TextFormatting getTextColor(LunarMothJarItem item) {
        switch (item.getColor()) {
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
        }
        return TextFormatting.AQUA;
    }
}

