/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.client.renders;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.vulp.druidcraft.client.models.DreadfishEntityModel;
import com.vulp.druidcraft.entities.DreadfishEntity;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class DreadfishEntityRender
extends MobRenderer<DreadfishEntity, DreadfishEntityModel> {
    private static final ResourceLocation DREADFISH_HEALTH_FULL = new ResourceLocation("druidcraft", "textures/entity/dreadfish/dreadfish_0.png");
    private static final ResourceLocation DREADFISH_HEALTH_HIGH = new ResourceLocation("druidcraft", "textures/entity/dreadfish/dreadfish_1.png");
    private static final ResourceLocation DREADFISH_HEALTH_MEDIUM = new ResourceLocation("druidcraft", "textures/entity/dreadfish/dreadfish_2.png");
    private static final ResourceLocation DREADFISH_HEALTH_LOW = new ResourceLocation("druidcraft", "textures/entity/dreadfish/dreadfish_3.png");

    public DreadfishEntityRender(EntityRendererManager manager) {
        super(manager, (EntityModel)new DreadfishEntityModel(), 0.3f);
    }

    public ResourceLocation getEntityTexture(DreadfishEntity entity) {
        if (entity.isTamed()) {
            if (entity.func_110143_aJ() >= entity.func_110138_aP()) {
                return DREADFISH_HEALTH_FULL;
            }
            if (entity.func_110143_aJ() < entity.func_110138_aP() && entity.func_110143_aJ() >= 16.0f) {
                return DREADFISH_HEALTH_HIGH;
            }
            if (entity.func_110143_aJ() < 16.0f && entity.func_110143_aJ() >= 8.0f) {
                return DREADFISH_HEALTH_MEDIUM;
            }
            if (entity.func_110143_aJ() < 8.0f) {
                return DREADFISH_HEALTH_LOW;
            }
            return DREADFISH_HEALTH_FULL;
        }
        return DREADFISH_HEALTH_FULL;
    }

    protected void applyRotations(DreadfishEntity entityLiving, MatrixStack matrix, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrix, ageInTicks, rotationYaw, partialTicks);
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = f * 4.3f * MathHelper.func_76126_a((float)(f1 * 0.6f * ageInTicks));
        if (!entityLiving.isSitting()) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f2));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
        } else {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 / 3.0f));
        }
        matrix.func_227861_a_(0.0, 0.05 * (double)MathHelper.func_76126_a((float)(ageInTicks * 0.2f)), (double)-0.4f);
    }

    public static class RenderFactory
    implements IRenderFactory<DreadfishEntity> {
        public EntityRenderer<? super DreadfishEntity> createRenderFor(EntityRendererManager manager) {
            return new DreadfishEntityRender(manager);
        }
    }
}

