/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.vulp.druidcraft.Druidcraft;
import com.vulp.druidcraft.config.DropRateConfig;
import com.vulp.druidcraft.config.EntitySpawnConfig;
import com.vulp.druidcraft.config.HarvestConfig;
import com.vulp.druidcraft.config.WorldGenConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Configuration {
    private static final ForgeConfigSpec.Builder server_builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec server_config;
    private static final ForgeConfigSpec.Builder client_builder;
    public static final ForgeConfigSpec client_config;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        Druidcraft.LOGGER.info("Loading Config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Druidcraft.LOGGER.info("Built Config: " + path);
        file.load();
        Druidcraft.LOGGER.info("Loaded Config: " + path);
        config.setConfig((CommentedConfig)file);
    }

    static {
        client_builder = new ForgeConfigSpec.Builder();
        WorldGenConfig.init(server_builder, client_builder);
        DropRateConfig.init(server_builder, client_builder);
        HarvestConfig.init(server_builder, client_builder);
        EntitySpawnConfig.init(server_builder, client_builder);
        server_config = server_builder.build();
        client_config = client_builder.build();
    }
}

