/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.inventory.container;

import com.vulp.druidcraft.blocks.tileentities.CrateTileEntity;
import com.vulp.druidcraft.registry.GUIRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CrateContainer
extends Container {
    private IItemHandler mainCrateInv;
    private final int numRows;
    private CrateTileEntity crate;

    private CrateContainer(ContainerType<?> type, int id, PlayerInventory player, int rows) {
        this(type, id, player, (IItemHandler)new ItemStackHandler(9 * rows), rows, null);
    }

    public CrateTileEntity getCrate() {
        return this.crate;
    }

    public static CrateContainer createGeneric9X3(int id, PlayerInventory player) {
        return new CrateContainer(GUIRegistry.generic_9X3, id, player, 3);
    }

    public static CrateContainer createGeneric9X6(int id, PlayerInventory player) {
        return new CrateContainer(GUIRegistry.generic_9X6, id, player, 6);
    }

    public static CrateContainer createGeneric9X12(int id, PlayerInventory player) {
        return new CrateContainer(GUIRegistry.generic_9X12, id, player, 12);
    }

    public static CrateContainer createGeneric9X24(int id, PlayerInventory player) {
        return new CrateContainer(GUIRegistry.generic_9X24, id, player, 24);
    }

    public CrateContainer(ContainerType<?> type, int id, PlayerInventory playerInventoryIn, IItemHandler inventory, int rows, @Nullable CrateTileEntity tile) {
        super(type, id);
        int j1;
        int i1;
        int k;
        int j;
        CrateContainer.assertIItemHandlerSize(inventory, rows * 9);
        this.mainCrateInv = inventory;
        this.numRows = rows;
        this.crate = tile;
        if (this.crate != null) {
            this.crate.openInventory(playerInventoryIn.field_70458_d);
        }
        int playerInventoryStart = this.numRows * 18;
        if (rows == 3 || rows == 6) {
            int j2;
            int i;
            for (i = 0; i < this.numRows; ++i) {
                for (j2 = 0; j2 < 9; ++j2) {
                    this.func_75146_a((Slot)new SlotItemHandler(inventory, j2 + i * 9, 8 + j2 * 18, 18 + i * 18));
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j2 = 0; j2 < 9; ++j2) {
                    this.func_75146_a(new Slot((IInventory)playerInventoryIn, j2 + i * 9 + 9, 8 + j2 * 18, 31 + i * 18 + playerInventoryStart));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, i, 8 + i * 18, 89 + playerInventoryStart));
            }
        }
        if (rows == 12) {
            for (j = 0; j < 9; ++j) {
                for (k = 0; k < 12; ++k) {
                    this.func_75146_a((Slot)new SlotItemHandler(inventory, k + j * 12, 8 + k * 18, 18 + j * 18));
                }
            }
            for (i1 = 0; i1 < 3; ++i1) {
                for (j1 = 0; j1 < 9; ++j1) {
                    this.func_75146_a(new Slot((IInventory)playerInventoryIn, j1 + i1 * 9 + 9, 35 + j1 * 18, 194 + i1 * 18));
                }
            }
            for (i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, i1, 35 + i1 * 18, 252));
            }
        }
        if (rows == 24) {
            for (j = 0; j < 12; ++j) {
                for (k = 0; k < 18; ++k) {
                    this.func_75146_a((Slot)new SlotItemHandler(inventory, k + j * 18, 8 + k * 18, 18 + j * 18));
                }
            }
            for (i1 = 0; i1 < 3; ++i1) {
                for (j1 = 0; j1 < 9; ++j1) {
                    this.func_75146_a(new Slot((IInventory)playerInventoryIn, j1 + i1 * 9 + 9, 89 + j1 * 18, 248 + i1 * 18));
                }
            }
            for (i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, i1, 89 + i1 * 18, 306));
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.numRows * 9 ? !this.func_75135_a(itemstack1, this.numRows * 9, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.numRows * 9, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (this.crate != null) {
            this.crate.closeInventory(playerIn);
        }
    }

    public IItemHandler getMainInventory() {
        return this.mainCrateInv;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.crate.func_145837_r()) {
            return false;
        }
        BlockPos pos = this.crate.func_174877_v();
        return playerIn.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 64.0;
    }

    private static void assertIItemHandlerSize(IItemHandler inventoryIn, int minSize) {
        int i = inventoryIn.getSlots();
        if (i < minSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + minSize);
        }
    }
}

