/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.items;

import com.vulp.druidcraft.entities.LunarMothColors;
import com.vulp.druidcraft.entities.LunarMothEntity;
import com.vulp.druidcraft.registry.EntityRegistry;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LunarMothJarItem
extends BlockItem {
    private final LunarMothColors color;

    public LunarMothJarItem(Block block, LunarMothColors color, Item.Properties properties) {
        super(block, properties);
        this.color = color;
    }

    public LunarMothColors getColor() {
        return this.color;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j().func_225608_bj_()) {
            ActionResultType actionresulttype1 = this.func_195942_a(new BlockItemUseContext(context));
            return actionresulttype1 != ActionResultType.SUCCESS ? this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a() : actionresulttype1;
        }
        ActionResultType actionresulttype2 = this.tryRelease((ItemUseContext)new BlockItemUseContext(context));
        return actionresulttype2 != ActionResultType.SUCCESS ? this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a() : actionresulttype2;
    }

    public ActionResultType tryRelease(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        PlayerEntity player = context.func_195999_j();
        LunarMothEntity moth = (LunarMothEntity)EntityRegistry.lunar_moth_entity.func_220331_a(world, itemstack, player, blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (moth != null) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("Color", LunarMothColors.colorToInt(this.color));
            moth.func_70037_a(nbt);
            if (player != null && !player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            ItemStack bottle = new ItemStack((IItemProvider)Items.field_151069_bo);
            if (player != null) {
                if (!player.field_71071_by.func_70441_a(bottle)) {
                    player.func_71019_a(bottle, false);
                }
            } else {
                InventoryHelper.func_180173_a((World)world, (double)((double)blockpos1.func_177958_n() + 0.5), (double)((double)blockpos1.func_177956_o() + 0.5), (double)((double)blockpos1.func_177952_p() + 0.5), (ItemStack)bottle);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static LunarMothJarItem getItemByColor(LunarMothColors color) {
        switch (color) {
            case YELLOW: {
                return (LunarMothJarItem)ItemRegistry.lunar_moth_jar_yellow;
            }
            case PINK: {
                return (LunarMothJarItem)ItemRegistry.lunar_moth_jar_pink;
            }
            case LIME: {
                return (LunarMothJarItem)ItemRegistry.lunar_moth_jar_lime;
            }
            case WHITE: {
                return (LunarMothJarItem)ItemRegistry.lunar_moth_jar_white;
            }
            case ORANGE: {
                return (LunarMothJarItem)ItemRegistry.lunar_moth_jar_orange;
            }
        }
        return (LunarMothJarItem)ItemRegistry.lunar_moth_jar_turquoise;
    }

    public static ItemStack getItemStackByColor(LunarMothColors color) {
        return new ItemStack((IItemProvider)LunarMothJarItem.getItemByColor(color));
    }
}

