/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.registry;

import com.vulp.druidcraft.world.features.ElderTreeFeatureConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FeatureRegistry {
    public static Feature<ElderTreeFeatureConfig> elder_tree;
    public static ElderTreeFeatureConfig elder_tree_feature;
    public static BlockClusterFeatureConfig blueberry_bush_feature;
    public static BlockClusterFeatureConfig lavender_feature;

    public static <V extends R, R extends IForgeRegistryEntry<R>> V register(IForgeRegistry<R> registry, V feature, String name) {
        ResourceLocation id = new ResourceLocation("druidcraft", name);
        feature.setRegistryName(id);
        registry.register(feature);
        return feature;
    }

    public static void spawnFeatures() {
        FeatureRegistry.addBlueberryBushes();
        FeatureRegistry.addElderTrees();
        FeatureRegistry.addLavenderPatches();
    }

    public static void addElderTrees() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if ((BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HILLS) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.MOUNTAIN)) && BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.WET)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, elder_tree.func_225566_b_((IFeatureConfig)elder_tree_feature).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.015f, 1))));
                continue;
            }
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HILLS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.MOUNTAIN)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, elder_tree.func_225566_b_((IFeatureConfig)elder_tree_feature).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1))));
        }
    }

    public static void addBlueberryBushes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HILLS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.CONIFEROUS)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)blueberry_bush_feature).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(12))));
        }
    }

    public static void addLavenderPatches() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)lavender_feature).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        }
    }
}

