/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.util;

import com.vulp.druidcraft.items.EffectiveSickleItem;
import com.vulp.druidcraft.items.RadialToolItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class SickleHarvestUtil {
    public static void breakNeighbours(ItemStack tool, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        int silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool);
        int blocksBroken = 0;
        for (BlockPos target : SickleHarvestUtil.nearbyBlocks(tool, pos, world, player)) {
            BlockState state = world.func_180495_p(target);
            EffectiveSickleItem sickleItem = (EffectiveSickleItem)tool.func_77973_b();
            if (!sickleItem.getEffectiveBlocks().contains(state.func_177230_c()) && !sickleItem.getEffectiveMaterials().contains(state.func_185904_a())) continue;
            world.func_175655_b(target, false);
            state.func_177230_c().func_180657_a(world, player, target, state, null, tool);
            ++blocksBroken;
        }
        tool.func_222118_a(Math.round(blocksBroken / 2), (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
    }

    public static Set<BlockPos> nearbyBlocks(ItemStack tool, BlockPos pos, World world, PlayerEntity player) {
        int radius = ((RadialToolItem)tool.func_77973_b()).getRadius();
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (int y = -1; y < 2; ++y) {
            for (int x = -radius; x < radius + 1; ++x) {
                for (int z = -radius; z < radius + 1; ++z) {
                    EffectiveSickleItem sickleItem;
                    BlockPos potential;
                    BlockState state;
                    if (x == z && y == z && z == 0 || BlockTags.field_219755_X.func_199685_a_((Object)(state = world.func_180495_p(potential = pos.func_177982_a(x, y, z))).func_177230_c()) || !ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)potential) || !(sickleItem = (EffectiveSickleItem)tool.func_77973_b()).getEffectiveBlocks().contains(state.func_177230_c()) && !sickleItem.getEffectiveMaterials().contains(state.func_185904_a())) continue;
                    result.add(potential);
                }
            }
        }
        return result;
    }
}

