/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.world.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.vulp.druidcraft.registry.BlockRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.common.IPlantable;

public class ElderTreeFeatureConfig
extends BaseTreeFeatureConfig {
    public final BlockStateProvider baseProvider;
    public final BlockStateProvider field_227368_m_;
    public final BlockStateProvider field_227369_n_;
    public final List<TreeDecorator> field_227370_o_;
    public final int field_227371_p_;
    public transient boolean field_227372_q_;
    protected IPlantable sapling = (IPlantable)BlockRegistry.elder_sapling;

    protected ElderTreeFeatureConfig(BlockStateProvider baseProviderIn, BlockStateProvider trunkProviderIn, BlockStateProvider leavesProviderIn, List<TreeDecorator> decoratorsIn, int baseHeightIn) {
        super(baseProviderIn, trunkProviderIn, decoratorsIn, baseHeightIn);
        this.baseProvider = baseProviderIn;
        this.field_227368_m_ = trunkProviderIn;
        this.field_227369_n_ = leavesProviderIn;
        this.field_227370_o_ = decoratorsIn;
        this.field_227371_p_ = baseHeightIn;
    }

    public void func_227373_a_() {
        this.field_227372_q_ = true;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("base_provider"), this.baseProvider.func_218175_a(ops)).put(ops.createString("trunk_provider"), this.field_227368_m_.func_218175_a(ops)).put(ops.createString("leaves_provider"), this.field_227369_n_.func_218175_a(ops)).put(ops.createString("decorators"), ops.createList(this.field_227370_o_.stream().map(p_227375_1_ -> p_227375_1_.func_218175_a(ops)))).put(ops.createString("base_height"), ops.createInt(this.field_227371_p_));
        return new Dynamic(ops, ops.createMap((Map)builder.build()));
    }

    protected ElderTreeFeatureConfig setSapling(IPlantable value) {
        this.sapling = value;
        return this;
    }

    public IPlantable getSapling() {
        return this.sapling;
    }

    public static <T> ElderTreeFeatureConfig deserialize(Dynamic<T> data) {
        BlockStateProviderType blockstateprovidertype = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)data.get("base_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType blockstateprovidertype1 = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)data.get("trunk_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        BlockStateProviderType blockstateprovidertype2 = (BlockStateProviderType)Registry.field_229387_t_.func_82594_a(new ResourceLocation((String)data.get("leaves_provider").get("type").asString().orElseThrow(RuntimeException::new)));
        return new ElderTreeFeatureConfig(blockstateprovidertype.func_227399_a_(data.get("base_provider").orElseEmptyMap()), blockstateprovidertype1.func_227399_a_(data.get("trunk_provider").orElseEmptyMap()), blockstateprovidertype2.func_227399_a_(data.get("leaves_provider").orElseEmptyMap()), data.get("decorators").asList(p_227374_0_ -> ((TreeDecoratorType)Registry.field_229390_w_.func_82594_a(new ResourceLocation((String)p_227374_0_.get("type").asString().orElseThrow(RuntimeException::new)))).func_227431_a_(p_227374_0_)), data.get("base_height").asInt(0));
    }

    public static class Builder {
        public final BlockStateProvider baseProvider;
        public final BlockStateProvider trunkProvider;
        public final BlockStateProvider leavesProvider;
        private List<TreeDecorator> decorators = Lists.newArrayList();
        private int baseHeight = 0;
        protected IPlantable sapling = (IPlantable)Blocks.field_196674_t;

        public Builder(BlockStateProvider baseProviderIn, BlockStateProvider trunkProviderIn, BlockStateProvider leavesProviderIn) {
            this.baseProvider = baseProviderIn;
            this.trunkProvider = trunkProviderIn;
            this.leavesProvider = leavesProviderIn;
        }

        public Builder baseHeight(int baseHeightIn) {
            this.baseHeight = baseHeightIn;
            return this;
        }

        public Builder setSapling(IPlantable value) {
            this.sapling = value;
            return this;
        }

        public ElderTreeFeatureConfig build() {
            return new ElderTreeFeatureConfig(this.baseProvider, this.trunkProvider, this.leavesProvider, this.decorators, this.baseHeight).setSapling(this.sapling);
        }
    }
}

