/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.ConfigFlagManager;
import vazkii.quark.base.module.ConfigObjectSerializer;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

public class ConfigResolver {
    private final ConfigFlagManager flagManager;
    private List<Runnable> refreshRunnables = new LinkedList<Runnable>();

    public ConfigResolver() {
        this.flagManager = new ConfigFlagManager();
    }

    public void makeSpec() {
        ForgeConfigSpec spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(this::build).getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, spec);
    }

    public void configChanged() {
        this.flagManager.clear();
        this.refreshRunnables.forEach(Runnable::run);
    }

    private Void build(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        try {
            ConfigObjectSerializer.serialize(builder, this.flagManager, this.refreshRunnables, GeneralConfig.INSTANCE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create quark general config", e);
        }
        builder.pop();
        builder.push("categories");
        this.buildCategoryList(builder);
        builder.pop();
        for (ModuleCategory category : ModuleCategory.values()) {
            this.buildCategory(builder, category);
        }
        return null;
    }

    private void buildCategoryList(ForgeConfigSpec.Builder builder) {
        for (ModuleCategory category : ModuleCategory.values()) {
            ForgeConfigSpec.BooleanValue value = builder.define(WordUtils.capitalizeFully((String)category.name), true);
            this.refreshRunnables.add(() -> ConfigResolver.lambda$buildCategoryList$0(category, (ForgeConfigSpec.ConfigValue)value));
        }
    }

    private void buildCategory(ForgeConfigSpec.Builder builder, ModuleCategory category) {
        builder.push(category.name);
        List<Module> modules = category.getOwnedModules();
        HashMap<Module, Runnable> setEnabledRunnables = new HashMap<Module, Runnable>();
        for (Module module : modules) {
            ForgeConfigSpec.BooleanValue value = builder.define(module.displayName, module.enabledByDefault);
            setEnabledRunnables.put(module, () -> this.lambda$buildCategory$1(module, (ForgeConfigSpec.ConfigValue)value, category));
        }
        for (Module module : modules) {
            this.buildModule(builder, module, (Runnable)setEnabledRunnables.get(module));
        }
        builder.pop();
    }

    private void buildModule(ForgeConfigSpec.Builder builder, Module module, Runnable setEnabled) {
        if (!module.description.isEmpty()) {
            builder.comment(module.description);
        }
        builder.push(module.lowercaseName);
        if (module.antiOverlap != null && module.antiOverlap.size() > 0) {
            this.addModuleAntiOverlap(builder, module);
        }
        this.refreshRunnables.add(setEnabled);
        try {
            ConfigObjectSerializer.serialize(builder, this.flagManager, this.refreshRunnables, module);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create config spec for module " + module.displayName, e);
        }
        this.refreshRunnables.add(() -> module.pushFlags(this.flagManager));
        module.buildConfigSpec(builder, this.refreshRunnables);
        builder.pop();
    }

    private void addModuleAntiOverlap(ForgeConfigSpec.Builder builder, Module module) {
        StringBuilder desc = new StringBuilder("This feature disables itself if any of the following mods are loaded: \n");
        for (String s : module.antiOverlap) {
            desc.append(" - ").append(s).append("\n");
        }
        desc.append("This is done to prevent content overlap.\nYou can turn this on to force the feature to be loaded even if the above mods are also loaded.");
        String descStr = desc.toString();
        builder.comment(descStr);
        ForgeConfigSpec.BooleanValue value = builder.define("Ignore Anti Overlap", false);
        this.refreshRunnables.add(() -> ConfigResolver.lambda$addModuleAntiOverlap$3(module, (ForgeConfigSpec.ConfigValue)value));
    }

    private static /* synthetic */ void lambda$addModuleAntiOverlap$3(Module module, ForgeConfigSpec.ConfigValue value) {
        module.ignoreAntiOverlap = !GeneralConfig.useAntiOverlap || (Boolean)value.get() != false;
    }

    private /* synthetic */ void lambda$buildCategory$1(Module module, ForgeConfigSpec.ConfigValue value, ModuleCategory category) {
        module.setEnabled((Boolean)value.get() != false && category.enabled);
        this.flagManager.putEnabledFlag(module);
    }

    private static /* synthetic */ void lambda$buildCategoryList$0(ModuleCategory category, ForgeConfigSpec.ConfigValue value) {
        category.enabled = (Boolean)value.get();
    }
}

