/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.Generator;
import vazkii.quark.building.module.CompressedBlocksModule;
import vazkii.quark.world.module.NetherObsidianSpikesModule;

public class ObsidianSpikeGenerator
extends Generator {
    public ObsidianSpikeGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    @Override
    public void generateChunk(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos chunkCorner) {
        if ((double)rand.nextFloat() < NetherObsidianSpikesModule.chancePerChunk) {
            block0: for (int i = 0; i < NetherObsidianSpikesModule.triesPerChunk; ++i) {
                BlockPos pos = chunkCorner.func_177982_a(rand.nextInt(16), 50, rand.nextInt(16));
                while (pos.func_177956_o() > 10) {
                    BlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == Blocks.field_150353_l) {
                        ObsidianSpikeGenerator.placeSpikeAt(world, pos, rand);
                        continue block0;
                    }
                    pos = pos.func_177977_b();
                }
            }
        }
    }

    public static void placeSpikeAt(IWorld world, BlockPos pos, Random rand) {
        int i;
        int heightBelow = 10;
        int heightBottom = 3 + rand.nextInt(3);
        int heightMiddle = 2 + rand.nextInt(4);
        int heightTop = 2 + rand.nextInt(3);
        boolean addSpawner = false;
        if ((double)rand.nextFloat() < NetherObsidianSpikesModule.bigSpikeChance) {
            heightBottom += 7;
            heightMiddle += 8;
            heightTop += 4;
            addSpawner = NetherObsidianSpikesModule.bigSpikeSpawners;
        }
        int checkHeight = heightBottom + heightMiddle + heightTop + 2;
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < checkHeight; ++k) {
                    BlockPos checkPos = pos.func_177982_a(i2 - 2, k, j - 2);
                    if (world.func_175623_d(checkPos) || world.func_180495_p(checkPos).func_185904_a() == Material.field_151587_i) continue;
                    return;
                }
            }
        }
        BlockState obsidian = Blocks.field_150343_Z.func_176223_P();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < heightBottom + heightBelow; ++k) {
                    BlockPos placePos = pos.func_177982_a(i - 1, k - heightBelow, j - 1);
                    if (world.func_180495_p(placePos).func_185887_b((IBlockReader)world, placePos) == -1.0f) continue;
                    world.func_180501_a(placePos, obsidian, 0);
                }
            }
        }
        for (i = 0; i < heightMiddle; ++i) {
            BlockPos placePos = pos.func_177982_a(0, heightBottom + i, 0);
            world.func_180501_a(placePos, obsidian, 0);
            for (Direction face : MiscUtil.HORIZONTALS) {
                world.func_180501_a(placePos.func_177972_a(face), obsidian, 0);
            }
        }
        for (i = 0; i < heightTop; ++i) {
            BlockPos placePos = pos.func_177982_a(0, heightBottom + heightMiddle + i, 0);
            world.func_180501_a(placePos, obsidian, 0);
            if (!addSpawner || i != 0) continue;
            boolean useBlazeLantern = ModuleLoader.INSTANCE.isModuleEnabled(CompressedBlocksModule.class) && CompressedBlocksModule.enableBlazeLantern;
            world.func_180501_a(placePos, useBlazeLantern ? CompressedBlocksModule.blaze_lantern.func_176223_P() : Blocks.field_150426_aN.func_176223_P(), 0);
            placePos = placePos.func_177977_b();
            world.func_180501_a(placePos, Blocks.field_150474_ac.func_176223_P(), 0);
            ((MobSpawnerTileEntity)world.func_175625_s(placePos)).func_145881_a().func_200876_a(EntityType.field_200792_f);
            placePos = placePos.func_177977_b();
            world.func_180501_a(placePos, Blocks.field_150486_ae.func_176223_P(), 0);
            ((ChestTileEntity)world.func_175625_s(placePos)).func_189404_a(new ResourceLocation("minecraft", "chests/nether_bridge"), rand.nextLong());
        }
    }
}

