/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.library;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntitySpawnHandler {
    protected static Predicate<Biome> coldOceanCondition() {
        return biome -> biome.func_201856_r() == Biome.Category.OCEAN && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD);
    }

    protected static Predicate<Biome> notColdOceanCondition() {
        return biome -> biome.func_201856_r() == Biome.Category.OCEAN && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD);
    }

    protected static Predicate<Biome> hotOceanCondition() {
        return biome -> biome.func_201856_r() == Biome.Category.OCEAN && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT);
    }

    protected static Predicate<Biome> warmishOceanCondition() {
        return biome -> biome == Biomes.field_203614_T || biome == Biomes.field_203615_U;
    }

    protected static class SpawnEntry {
        public final EntityClassification classification;
        public final int weight;
        public final int minGroup;
        public final int maxGroup;

        public SpawnEntry(EntityClassification classification, int weight, int minGroup, int maxGroup) {
            this.classification = classification;
            this.weight = weight;
            this.minGroup = minGroup;
            this.maxGroup = maxGroup;
        }
    }

    protected static class EntitySpawn<T extends MobEntity> {
        public final Supplier<EntityType<T>> entity;
        public final SpawnEntry spawnEntry;
        public final EntitySpawnPlacementRegistry.PlacementType placementType;
        public final Heightmap.Type heightmapType;
        public final EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate;
        public final Predicate<Biome> biomePredicate;

        public EntitySpawn(Supplier<EntityType<T>> entity, SpawnEntry spawnEntry, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightmapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate, Predicate<Biome> biomePredicate) {
            this.entity = entity;
            this.spawnEntry = spawnEntry;
            this.placementType = placementType;
            this.heightmapType = heightmapType;
            this.placementPredicate = placementPredicate;
            this.biomePredicate = biomePredicate;
        }

        public void registerSpawnPlacement() {
            EntitySpawnPlacementRegistry.func_209343_a(this.entity.get(), (EntitySpawnPlacementRegistry.PlacementType)this.placementType, (Heightmap.Type)this.heightmapType, this.placementPredicate);
        }

        public void processSpawnAddition() {
            ForgeRegistries.BIOMES.getEntries().stream().filter(biome -> this.biomePredicate.test((Biome)biome.getValue())).forEach(biome -> ((Biome)biome.getValue()).func_76747_a(this.spawnEntry.classification).add(new Biome.SpawnListEntry(this.entity.get(), this.spawnEntry.weight, this.spawnEntry.minGroup, this.spawnEntry.maxGroup)));
        }
    }
}

