/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.library.endimator;

import com.teamabnormals.abnormals_core.core.library.endimator.EndimationDataManager;
import com.teamabnormals.abnormals_core.core.library.endimator.EndimatorEntityModel;
import com.teamabnormals.abnormals_core.core.library.endimator.EndimatorModelRenderer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class Endimation {
    private int tickDuration;
    @Nullable
    private final ResourceLocation instructionsLocation;

    public Endimation(ResourceLocation instructionsLocation, int tickDuration) {
        this.instructionsLocation = instructionsLocation;
        this.tickDuration = tickDuration;
    }

    public Endimation(int tickDuration) {
        this(null, tickDuration);
    }

    public Endimation() {
        this(0);
    }

    public <E extends Entity> void processInstructions(EndimatorEntityModel<E> model) {
        Objects.requireNonNull(this.instructionsLocation, () -> "Instructions are null, this should not be the case!");
        EndimationDataManager.EndimationConversion conversion = EndimationDataManager.ENDIMATIONS.get(this.instructionsLocation);
        for (EndimationDataManager.EndimationInstruction instructions : conversion.getInstructions()) {
            EndimationDataManager.InstructionType type = instructions.type;
            int tickLength = instructions.tickLength;
            if (type == EndimationDataManager.InstructionType.START_KEYFRAME) {
                model.startKeyframe(tickLength);
                continue;
            }
            if (type == EndimationDataManager.InstructionType.END_KEYFRAME) {
                model.endKeyframe();
                continue;
            }
            if (type == EndimationDataManager.InstructionType.STATIC_KEYFRAME) {
                model.setStaticKeyframe(tickLength);
                continue;
            }
            if (type == EndimationDataManager.InstructionType.RESET_KEYFRAME) {
                model.resetKeyframe(tickLength);
                continue;
            }
            EndimationDataManager.EndimationInstruction.ModelRendererEndimationInstruction instruction = (EndimationDataManager.EndimationInstruction.ModelRendererEndimationInstruction)instructions;
            EndimatorModelRenderer modelRenderer = Endimation.getModelRendererByName(model, instruction.modelRenderer);
            float[] values = new float[]{instruction.x, instruction.y, instruction.z};
            if (type == EndimationDataManager.InstructionType.MOVE) {
                model.move(modelRenderer, values[0], values[1], values[2]);
                continue;
            }
            if (type == EndimationDataManager.InstructionType.ADD_MOVE) {
                model.moveAdditive(modelRenderer, values[0], values[1], values[2]);
                continue;
            }
            if (type == EndimationDataManager.InstructionType.ROTATE) {
                model.rotate(modelRenderer, (float)Math.toRadians(values[0]), (float)Math.toRadians(values[1]), (float)Math.toRadians(values[2]));
                continue;
            }
            if (type == EndimationDataManager.InstructionType.ADD_ROTATE) {
                model.rotateAdditive(modelRenderer, (float)Math.toRadians(values[0]), (float)Math.toRadians(values[1]), (float)Math.toRadians(values[2]));
                continue;
            }
            if (type == EndimationDataManager.InstructionType.OFFSET) {
                model.offset(modelRenderer, values[0], values[1], values[2]);
                continue;
            }
            if (type == EndimationDataManager.InstructionType.ADD_OFFSET) {
                model.offsetAdditive(modelRenderer, values[0], values[1], values[2]);
                continue;
            }
            if (type == EndimationDataManager.InstructionType.SCALE) {
                model.scale(modelRenderer, values[0], values[1], values[2]);
                continue;
            }
            if (type != EndimationDataManager.InstructionType.ADD_SCALE) continue;
            model.scaleAdditive(modelRenderer, values[0], values[1], values[2]);
        }
    }

    private static EndimatorModelRenderer getModelRendererByName(EndimatorEntityModel<?> model, String name) {
        List<EndimatorModelRenderer> boxes = model.savedBoxes;
        boxes.removeIf(box -> box.getName() == null || !box.getName().equals(name));
        if (boxes.isEmpty()) {
            throw new NullPointerException("No Model Renderer of the name \"" + name + "\" could be found");
        }
        return boxes.get(0);
    }

    public int getAnimationTickDuration() {
        return this.tickDuration;
    }
}

