/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.abnormals_core.client.renderer.ChestItemRenderer;
import com.teamabnormals.abnormals_core.common.blocks.chest.AbnormalsChestBlock;
import com.teamabnormals.abnormals_core.common.blocks.chest.AbnormalsTrappedChestBlock;
import com.teamabnormals.abnormals_core.common.blocks.sign.AbnormalsStandingSignBlock;
import com.teamabnormals.abnormals_core.common.blocks.sign.AbnormalsWallSignBlock;
import com.teamabnormals.abnormals_core.common.dispenser.SpawnEggDispenseBehavior;
import com.teamabnormals.abnormals_core.common.items.AbnormalsBoatItem;
import com.teamabnormals.abnormals_core.common.items.AbnormalsSignItem;
import com.teamabnormals.abnormals_core.common.items.AbnormalsSpawnEggItem;
import com.teamabnormals.abnormals_core.common.items.FuelItem;
import com.teamabnormals.abnormals_core.common.items.InjectedBlockItem;
import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsChestTileEntity;
import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsTrappedChestTileEntity;
import com.teamabnormals.abnormals_core.core.registry.BoatRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistryHelper {
    private final String modId;
    private final DeferredRegister<Item> itemRegister;
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<SoundEvent> soundRegister;
    private final DeferredRegister<TileEntityType<?>> tileEntityRegister;
    private final DeferredRegister<EntityType<?>> entityRegister;
    public final List<RegistryObject<Item>> spawnEggs = Lists.newArrayList();

    public RegistryHelper(String modId) {
        this.modId = modId;
        this.itemRegister = new DeferredRegister(ForgeRegistries.ITEMS, modId);
        this.blockRegister = new DeferredRegister(ForgeRegistries.BLOCKS, modId);
        this.soundRegister = new DeferredRegister(ForgeRegistries.SOUND_EVENTS, modId);
        this.tileEntityRegister = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, modId);
        this.entityRegister = new DeferredRegister(ForgeRegistries.ENTITIES, modId);
    }

    public DeferredRegister<Item> getDeferredItemRegister() {
        return this.itemRegister;
    }

    public DeferredRegister<Block> getDeferredBlockRegister() {
        return this.blockRegister;
    }

    public DeferredRegister<SoundEvent> getDeferredSoundRegister() {
        return this.soundRegister;
    }

    public DeferredRegister<TileEntityType<?>> getDeferredTileEntityRegister() {
        return this.tileEntityRegister;
    }

    public DeferredRegister<EntityType<?>> getDeferredEntityRegister() {
        return this.entityRegister;
    }

    public String getModId() {
        return this.modId;
    }

    public ResourceLocation prefix(String name) {
        return new ResourceLocation(this.modId, name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSpawnEggColors(ColorHandlerEvent.Item event) {
        for (RegistryObject<Item> items : this.spawnEggs) {
            Item item;
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, items, (String)"value") == null || !((item = (Item)items.get()) instanceof AbnormalsSpawnEggItem)) continue;
            event.getItemColors().func_199877_a((itemColor, itemsIn) -> ((AbnormalsSpawnEggItem)item).func_195983_a(itemsIn), new IItemProvider[]{item});
        }
    }

    public void processSpawnEggDispenseBehaviors() {
        for (RegistryObject<Item> items : this.spawnEggs) {
            Item item = (Item)items.get();
            if (!(item instanceof AbnormalsSpawnEggItem)) continue;
            DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)new SpawnEggDispenseBehavior());
        }
    }

    public <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        RegistryObject item = this.itemRegister.register(name, supplier);
        return item;
    }

    public RegistryObject<Item> createCompatItem(String modId, String name, Item.Properties properties, ItemGroup group) {
        ItemGroup determinedGroup = ModList.get().isLoaded(modId) || modId == "indev" ? group : null;
        RegistryObject item = this.itemRegister.register(name, () -> new Item(properties.func_200916_a(determinedGroup)));
        return item;
    }

    public RegistryObject<Item> createSpawnEggItem(String entityName, Supplier<EntityType<?>> supplier, int primaryColor, int secondaryColor) {
        RegistryObject spawnEgg = this.itemRegister.register(entityName + "_spawn_egg", () -> new AbnormalsSpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        this.spawnEggs.add((RegistryObject<Item>)spawnEgg);
        return spawnEgg;
    }

    public RegistryObject<Item> createBoatItem(String wood, RegistryObject<Block> block) {
        String type = this.getModId() + ":" + wood;
        RegistryObject boat = this.itemRegister.register(wood + "_boat", () -> new AbnormalsBoatItem(type, RegistryHelper.createSimpleItemProperty(1, ItemGroup.field_78029_e)));
        BoatRegistry.registerBoat(type, (RegistryObject<Item>)boat, block);
        return boat;
    }

    public static Item.Properties createSimpleItemProperty(int stackSize, ItemGroup itemGroup) {
        return new Item.Properties().func_200916_a(itemGroup).func_200917_a(stackSize);
    }

    public static BlockItem createWallOrFloorItem(Block floorBlock, Block wallBlock, ItemGroup itemGroup) {
        return new WallOrFloorItem(floorBlock, wallBlock, new Item.Properties().func_200916_a(itemGroup));
    }

    public static BlockItem createTallBlockItem(Block blockForInput, ItemGroup itemGroup) {
        return new TallBlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup));
    }

    public static Item createSimpleItem(ItemGroup itemGroup) {
        return new Item(new Item.Properties().func_200916_a(itemGroup));
    }

    public static FuelItem createFuelItem(int burnTime, ItemGroup itemGroup) {
        return new FuelItem(burnTime, new Item.Properties().func_200916_a(itemGroup));
    }

    public static BlockItem createSimpleBlockItem(Block blockForInput, @Nullable ItemGroup itemGroup) {
        return (BlockItem)new BlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(blockForInput.getRegistryName());
    }

    @Deprecated
    public static BlockItem createNoTabBlockItem(Block blockForInput) {
        return (BlockItem)new BlockItem(blockForInput, new Item.Properties()).setRegistryName(blockForInput.getRegistryName());
    }

    public <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        RegistryObject block = this.blockRegister.register(name, supplier);
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = this.blockRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createInjectedBlock(String name, Item followItem, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = this.getDeferredBlockRegister().register(name, supplier);
        this.getDeferredItemRegister().register(name, () -> new InjectedBlockItem(followItem, (Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithISTER(String name, Supplier<? extends B> supplier, Supplier<Callable<ItemStackTileEntityRenderer>> ister, @Nullable ItemGroup group) {
        RegistryObject block = this.blockRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(ister)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createTallBlock(String name, Supplier<? extends B> supplier, ItemGroup group) {
        RegistryObject block = this.blockRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new TallBlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createWallOrFloorBlock(String name, Supplier<? extends B> supplier, Supplier<? extends B> wallSupplier, @Nullable ItemGroup group) {
        RegistryObject block = this.getDeferredBlockRegister().register(name, supplier);
        this.getDeferredItemRegister().register(name, () -> new WallOrFloorItem((Block)block.get(), (Block)wallSupplier.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createRareBlock(String name, Supplier<? extends B> supplier, Rarity rarity, @Nullable ItemGroup group) {
        RegistryObject block = this.getDeferredBlockRegister().register(name, supplier);
        this.getDeferredItemRegister().register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_208103_a(rarity).func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<AbnormalsChestBlock> createChestBlock(String name, Block.Properties properties, @Nullable ItemGroup group) {
        RegistryObject block = this.blockRegister.register(name + "_chest", () -> new AbnormalsChestBlock(this.getModId(), name, properties));
        this.itemRegister.register(name + "_chest", () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(() -> RegistryHelper.chestISTER())));
        return block;
    }

    public <B extends Block> RegistryObject<AbnormalsTrappedChestBlock> createTrappedChestBlock(String name, Block.Properties properties, @Nullable ItemGroup group) {
        RegistryObject block = this.blockRegister.register(name + "_trapped_chest", () -> new AbnormalsTrappedChestBlock(this.getModId(), name, properties));
        this.itemRegister.register(name + "_trapped_chest", () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(() -> RegistryHelper.trappedChestISTER())));
        return block;
    }

    public Pair<RegistryObject<AbnormalsChestBlock>, RegistryObject<AbnormalsTrappedChestBlock>> createCompatChestBlocks(String name, MaterialColor color) {
        ItemGroup chestGroup = ModList.get().isLoaded("quark") || this.modId == "indev" ? ItemGroup.field_78031_c : null;
        ItemGroup trappedChestGroup = ModList.get().isLoaded("quark") || this.modId == "indev" ? ItemGroup.field_78028_d : null;
        RegistryObject chest = this.blockRegister.register(name + "_chest", () -> new AbnormalsChestBlock(this.getModId(), name, Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        RegistryObject trappedChest = this.blockRegister.register(name + "_trapped_chest", () -> new AbnormalsTrappedChestBlock(this.getModId(), name, Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        this.itemRegister.register(name + "_chest", () -> new BlockItem((Block)chest.get(), new Item.Properties().func_200916_a(chestGroup).setISTER(() -> RegistryHelper.chestISTER())));
        this.itemRegister.register(name + "_trapped_chest", () -> new BlockItem((Block)trappedChest.get(), new Item.Properties().func_200916_a(trappedChestGroup).setISTER(() -> RegistryHelper.trappedChestISTER())));
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    public Pair<RegistryObject<AbnormalsStandingSignBlock>, RegistryObject<AbnormalsWallSignBlock>> createSignBlock(String name, MaterialColor color) {
        ResourceLocation texture = new ResourceLocation(this.getModId(), "textures/entity/signs/" + name + ".png");
        RegistryObject standing = this.blockRegister.register(name + "_sign", () -> new AbnormalsStandingSignBlock(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), texture));
        RegistryObject wall = this.blockRegister.register(name + "_wall_sign", () -> new AbnormalsWallSignBlock(Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_222379_b((Block)standing.get()), texture));
        this.createItem(name + "_sign", () -> new AbnormalsSignItem((Block)standing.get(), (Block)wall.get(), new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        return Pair.of((Object)standing, (Object)wall);
    }

    public <B extends Block> RegistryObject<B> createCompatBlock(String modId, String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        ItemGroup determinedGroup = ModList.get().isLoaded(modId) || modId == "indev" ? group : null;
        RegistryObject block = this.blockRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(determinedGroup)));
        return block;
    }

    public RegistryObject<SoundEvent> createSoundEvent(String name) {
        return this.soundRegister.register(name, () -> new SoundEvent(this.prefix(name)));
    }

    public <T extends TileEntity> RegistryObject<TileEntityType<T>> createTileEntity(String name, Supplier<? extends T> tileEntity, Supplier<Block[]> validBlocks) {
        return this.tileEntityRegister.register(name, () -> new TileEntityType(tileEntity, (Set)Sets.newHashSet((Object[])((Object[])validBlocks.get())), null));
    }

    public <E extends LivingEntity> RegistryObject<EntityType<E>> createLivingEntity(String name, EntityType.IFactory<E> factory, EntityClassification entityClassification, float width, float height) {
        return this.entityRegister.register(name, () -> this.createLivingEntity(factory, entityClassification, name, width, height));
    }

    public <E extends Entity> RegistryObject<EntityType<E>> createEntity(String name, EntityType.IFactory<E> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, E> clientFactory, EntityClassification entityClassification, float width, float height) {
        return this.entityRegister.register(name, () -> this.createEntity(factory, clientFactory, entityClassification, name, width, height));
    }

    public <E extends LivingEntity> EntityType<E> createLivingEntity(EntityType.IFactory<E> factory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = this.prefix(name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_206830_a(location.toString());
        return entity;
    }

    public <E extends Entity> EntityType<E> createEntity(EntityType.IFactory<E> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, E> clientFactory, EntityClassification entityClassification, String name, float width, float height) {
        ResourceLocation location = this.prefix(name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setTrackingRange(64).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).setCustomClientFactory(clientFactory).func_206830_a(location.toString());
        return entity;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> chestISTER() {
        return () -> new ChestItemRenderer(AbnormalsChestTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> trappedChestISTER() {
        return () -> new ChestItemRenderer(AbnormalsTrappedChestTileEntity::new);
    }
}

