/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.server.command.TextComponentHelper;

public class ChunkGenWorker
implements WorldWorkerManager.IWorker {
    private final bn listener;
    protected final et start;
    protected final int total;
    private final int dim;
    private final Queue<et> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotifcationTime = 0L;
    private int genned = 0;
    private Boolean keepingLoaded;

    public ChunkGenWorker(bn listener, et start, int total, int dim, int interval) {
        this.listener = listener;
        this.start = start;
        this.total = total;
        this.dim = dim;
        this.queue = this.buildQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max(total / 20, 100);
        this.lastNotifcationTime = System.currentTimeMillis();
    }

    protected Queue<et> buildQueue() {
        ArrayDeque<et> ret = new ArrayDeque<et>();
        ret.add(this.start);
        int radius = 1;
        while (ret.size() < this.total) {
            int q;
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.a(radius, 0, q));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.a(q, 0, radius));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.a(-radius, 0, q));
            }
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.a(q, 0, -radius));
            }
            ++radius;
        }
        return ret;
    }

    @Deprecated
    public hp getStartMessage() {
        return new hp("commands.forge.gen.start", new Object[]{this.total, this.start.p(), this.start.r(), this.dim});
    }

    public he getStartMessage(bn sender) {
        return TextComponentHelper.createComponentTranslation(sender, "commands.forge.gen.start", this.total, this.start.p(), this.start.r(), this.dim);
    }

    @Override
    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    @Override
    public boolean doWork() {
        aye loader;
        oo world = DimensionManager.getWorld(this.dim);
        if (world == null) {
            DimensionManager.initDimension(this.dim);
            world = DimensionManager.getWorld(this.dim);
            if (world == null) {
                this.listener.a((hh)TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.dim_fail", this.dim));
                this.queue.clear();
                return false;
            }
        }
        aye aye2 = loader = world.r().d instanceof aye ? (aye)world.r().d : null;
        if (loader != null && loader.getPendingSaveCount() > 100) {
            if (this.lastNotifcationTime < System.currentTimeMillis() - 10000L) {
                this.listener.a((hh)TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.progress", this.total - this.queue.size(), this.total));
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            return false;
        }
        et next = this.queue.poll();
        if (next != null) {
            if (this.keepingLoaded == null) {
                this.keepingLoaded = DimensionManager.keepDimensionLoaded(this.dim, true);
            }
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotifcationTime < System.currentTimeMillis() - 60000L) {
                this.listener.a((hh)TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.progress", this.total - this.queue.size(), this.total));
                this.lastNotification = 0;
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            int x = next.p();
            int z = next.r();
            axw target = world.a(x, z);
            axw[] chunks = new axw[]{target};
            if (!target.u()) {
                chunks = new axw[]{target, world.a(x + 1, z), world.a(x + 1, z + 1), world.a(x, z + 1)};
                try {
                    world.r().d.a((amu)world, target);
                }
                catch (amv | IOException e2) {
                    this.listener.a((hh)TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.saveerror", e2.getMessage()));
                }
                ++this.genned;
            }
            for (axw chunk : chunks) {
                ot watchers = world.w().b(chunk.b, chunk.c);
                if (watchers != null) continue;
                world.r().a(chunk);
            }
        }
        if (this.queue.size() == 0) {
            this.listener.a((hh)TextComponentHelper.createComponentTranslation(this.listener, "commands.forge.gen.complete", this.genned, this.total, this.dim));
            if (this.keepingLoaded != null && this.keepingLoaded.booleanValue()) {
                DimensionManager.keepDimensionLoaded(this.dim, false);
            }
            return false;
        }
        return true;
    }
}

