/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackgroundScanHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService modContentScanner = Executors.newSingleThreadExecutor(r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        return thread;
    });
    private final List<ModFile> pendingFiles;
    private final List<ModFile> scannedFiles = new ArrayList<ModFile>();
    private final List<ModFile> allFiles;
    private LoadingModList loadingModList;

    public BackgroundScanHandler() {
        this.pendingFiles = new ArrayList<ModFile>();
        this.allFiles = new ArrayList<ModFile>();
    }

    public void submitForScanning(ModFile file) {
        if (this.modContentScanner.isShutdown()) {
            throw new IllegalStateException("Scanner has shutdown");
        }
        this.allFiles.add(file);
        this.pendingFiles.add(file);
        CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(file::compileContent, this.modContentScanner).whenComplete(file::setScanResult)).whenComplete((r, t) -> this.addCompletedFile(file, (ModFileScanData)r, (Throwable)t));
        file.setFutureScanResult((CompletableFuture<ModFileScanData>)future);
    }

    private void addCompletedFile(ModFile file, ModFileScanData modFileScanData, Throwable throwable) {
        if (throwable != null) {
            LOGGER.error(LogMarkers.SCAN, "An error occurred scanning file {}", (Object)file, (Object)throwable);
        }
        this.pendingFiles.remove(file);
        this.scannedFiles.add(file);
    }

    public List<ModFile> getScannedFiles() {
        if (!this.pendingFiles.isEmpty()) {
            this.modContentScanner.shutdown();
            try {
                this.modContentScanner.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.scannedFiles;
    }

    public List<ModFile> getAllFiles() {
        return this.allFiles;
    }

    public void setLoadingModList(LoadingModList loadingModList) {
        this.loadingModList = loadingModList;
    }

    public LoadingModList getLoadingModList() {
        return this.loadingModList;
    }
}

