/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;

public class BlockBed
extends BlockHorizontal
implements ITileEntityProvider {
    public static final EnumProperty<BedPart> field_176472_a = BlockStateProperties.field_208139_an;
    public static final BooleanProperty field_176471_b = BlockStateProperties.field_208192_s;
    protected static final VoxelShape field_196351_c = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 9.0, 16.0);
    private final EnumDyeColor field_196352_y;

    public BlockBed(EnumDyeColor colorIn, Block.Properties builder) {
        super(builder);
        this.field_196352_y = colorIn;
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)field_176471_b, Boolean.valueOf(false)));
    }

    public MaterialColor func_180659_g(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177229_b((IProperty)field_176472_a) == BedPart.FOOT ? this.field_196352_y.func_196055_e() : MaterialColor.field_151659_e;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (state.func_177229_b((IProperty)field_176472_a) != BedPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))))).func_177230_c() != this) {
            return true;
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != IForgeDimension.SleepResult.BED_EXPLODES) {
            EntityPlayer.SleepResult entityplayer$sleepresult;
            if (sleepResult == IForgeDimension.SleepResult.DENY) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176471_b)).booleanValue()) {
                EntityPlayer entityplayer = this.func_176470_e(worldIn, pos);
                if (entityplayer != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("block.minecraft.bed.occupied", new Object[0]), true);
                    return true;
                }
                state = (IBlockState)state.func_206870_a((IProperty)field_176471_b, Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 4);
            }
            if ((entityplayer$sleepresult = player.func_180469_a(pos)) == EntityPlayer.SleepResult.OK) {
                state = (IBlockState)state.func_206870_a((IProperty)field_176471_b, Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 4);
                return true;
            }
            if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.minecraft.bed.no_sleep", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.minecraft.bed.not_safe", new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("block.minecraft.bed.too_far_away", new Object[0]), true);
            }
            return true;
        }
        worldIn.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        worldIn.func_211529_a(null, DamageSource.func_199683_a(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    @Nullable
    private EntityPlayer func_176470_e(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x * (double)0.66f;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == BlockBed.func_208070_a((BedPart)stateIn.func_177229_b((IProperty)field_176472_a), (EnumFacing)((Object)stateIn.func_177229_b((IProperty)field_185512_D)))) {
            return facingState.func_177230_c() == this && facingState.func_177229_b((IProperty)field_176472_a) != stateIn.func_177229_b((IProperty)field_176472_a) ? (IBlockState)stateIn.func_206870_a((IProperty)field_176471_b, facingState.func_177229_b((IProperty)field_176471_b)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static EnumFacing func_208070_a(BedPart p_208070_0_, EnumFacing p_208070_1_) {
        return p_208070_0_ == BedPart.FOOT ? p_208070_1_ : p_208070_1_.func_176734_d();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            worldIn.func_175713_t(pos);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BedPart bedpart = (BedPart)state.func_177229_b((IProperty)field_176472_a);
        boolean flag = bedpart == BedPart.HEAD;
        BlockPos blockpos = pos.func_177972_a(BlockBed.func_208070_a(bedpart, (EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))));
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() == this && iblockstate.func_177229_b((IProperty)field_176472_a) != bedpart) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_180498_a(player, 2001, blockpos, Block.func_196246_j(iblockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                if (flag) {
                    state.func_196949_c(worldIn, pos, 0);
                } else {
                    iblockstate.func_196949_c(worldIn, blockpos, 0);
                }
            }
            player.func_71029_a(StatList.field_188065_ae.func_199076_b((Object)this));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        EnumFacing enumfacing = context.func_195992_f();
        BlockPos blockpos = context.func_195995_a();
        BlockPos blockpos1 = blockpos.func_177972_a(enumfacing);
        return context.func_195991_k().func_180495_p(blockpos1).func_196953_a(context) ? (IBlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)((Object)enumfacing)) : null;
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return state.func_177229_b((IProperty)field_176472_a) == BedPart.FOOT ? Items.field_190931_a : super.func_199769_a(state, worldIn, pos, fortune);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196351_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @Nullable
    public static BlockPos func_176468_a(IBlockReader worldIn, BlockPos pos, int tries) {
        EnumFacing enumfacing = (EnumFacing)((Object)worldIn.func_180495_p(pos).func_177229_b((IProperty)field_185512_D));
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockBed.func_176469_d(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean func_176469_d(IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176472_a, field_176471_b});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityBed(this.field_196352_y);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, @Nullable EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D)));
            worldIn.func_180501_a(blockpos, (IBlockState)state.func_206870_a((IProperty)field_176472_a, (Comparable)BedPart.HEAD), 3);
            worldIn.func_195592_c(pos, Blocks.field_150350_a);
            state.func_196946_a(worldIn, pos, 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumDyeColor func_196350_d() {
        return this.field_196352_y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(IBlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D)), state.func_177229_b((IProperty)field_176472_a) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

