/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockCactus
extends Block
implements IPlantable {
    public static final IntegerProperty field_176587_a = BlockStateProperties.field_208171_X;
    protected static final VoxelShape field_196400_b = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);
    protected static final VoxelShape field_196401_c = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    protected BlockCactus(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176587_a, Integer.valueOf(0)));
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.func_205050_e(pos, 1)) {
            return;
        }
        if (!state.func_196955_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            BlockPos blockpos = pos.func_177984_a();
            if (worldIn.func_175623_d(blockpos)) {
                int i = 1;
                while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                    ++i;
                }
                if (i < 3) {
                    int j = (Integer)state.func_177229_b((IProperty)field_176587_a);
                    if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)blockpos, (IBlockState)state, (boolean)true)) {
                        if (j == 15) {
                            worldIn.func_175656_a(blockpos, this.func_176223_P());
                            IBlockState iblockstate = (IBlockState)state.func_206870_a((IProperty)field_176587_a, Integer.valueOf(0));
                            worldIn.func_180501_a(pos, iblockstate, 4);
                            iblockstate.func_189546_a(worldIn, blockpos, this, pos);
                        } else {
                            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176587_a, Integer.valueOf(j + 1)), 4);
                        }
                        ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state);
                    }
                }
            }
        }
    }

    @Override
    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196400_b;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196401_c;
    }

    @Override
    public boolean func_200124_e(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c(worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(enumfacing));
            Material material = iblockstate.func_185904_a();
            if (!material.func_76220_a() && !worldIn.func_204610_c(pos.func_177972_a(enumfacing)).func_206884_a(FluidTags.field_206960_b)) continue;
            return false;
        }
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return soil.canSustainPlant((IBlockReader)worldIn, pos.func_177977_b(), EnumFacing.UP, this) && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
    }

    @Override
    public void func_196262_a(IBlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176587_a});
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public EnumPlantType getPlantType(IBlockReader world, BlockPos pos) {
        return EnumPlantType.Desert;
    }

    public IBlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

