/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Fluids;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockChest
extends BlockContainer
implements IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty field_176459_a = BlockHorizontal.field_185512_D;
    public static final EnumProperty<ChestType> field_196314_b = BlockStateProperties.field_208140_ao;
    public static final BooleanProperty field_204511_c = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_196316_c = Block.func_208617_a(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196317_y = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape field_196318_z = Block.func_208617_a(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape field_196313_A = Block.func_208617_a(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape field_196315_B = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);

    protected BlockChest(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176459_a, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)field_196314_b, (Comparable)ChestType.SINGLE)).func_206870_a((IProperty)field_204511_c, Boolean.valueOf(false)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204511_c)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        if (facingState.func_177230_c() == this && facing.func_176740_k().func_176722_c()) {
            ChestType chesttype = (ChestType)facingState.func_177229_b((IProperty)field_196314_b);
            if (stateIn.func_177229_b((IProperty)field_196314_b) == ChestType.SINGLE && chesttype != ChestType.SINGLE && stateIn.func_177229_b((IProperty)field_176459_a) == facingState.func_177229_b((IProperty)field_176459_a) && BlockChest.func_196311_i(facingState) == facing.func_176734_d()) {
                return (IBlockState)stateIn.func_206870_a((IProperty)field_196314_b, (Comparable)chesttype.func_208081_a());
            }
        } else if (BlockChest.func_196311_i(stateIn) == facing) {
            return (IBlockState)stateIn.func_206870_a((IProperty)field_196314_b, (Comparable)ChestType.SINGLE);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (state.func_177229_b((IProperty)field_196314_b) == ChestType.SINGLE) {
            return field_196315_B;
        }
        switch (BlockChest.func_196311_i(state)) {
            default: {
                return field_196316_c;
            }
            case SOUTH: {
                return field_196317_y;
            }
            case WEST: {
                return field_196318_z;
            }
            case EAST: 
        }
        return field_196313_A;
    }

    public static EnumFacing func_196311_i(IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_176459_a));
        return state.func_177229_b((IProperty)field_196314_b) == ChestType.LEFT ? enumfacing.func_176746_e() : enumfacing.func_176735_f();
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        EnumFacing enumfacing2;
        ChestType chesttype = ChestType.SINGLE;
        EnumFacing enumfacing = context.func_195992_f().func_176734_d();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = context.func_195998_g();
        EnumFacing enumfacing1 = context.func_196000_l();
        if (enumfacing1.func_176740_k().func_176722_c() && flag && (enumfacing2 = this.func_196312_a(context, enumfacing1.func_176734_d())) != null && enumfacing2.func_176740_k() != enumfacing1.func_176740_k()) {
            enumfacing = enumfacing2;
            ChestType chestType = chesttype = enumfacing2.func_176735_f() == enumfacing1.func_176734_d() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (enumfacing == this.func_196312_a(context, enumfacing.func_176746_e())) {
                chesttype = ChestType.LEFT;
            } else if (enumfacing == this.func_196312_a(context, enumfacing.func_176735_f())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_176459_a, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)field_196314_b, (Comparable)chesttype)).func_206870_a((IProperty)field_204511_c, Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)field_204511_c)).booleanValue()) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_204511_c, Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_204511_c) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, IBlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((IProperty)field_204511_c) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, IBlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)field_204511_c)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_204511_c, Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private EnumFacing func_196312_a(BlockItemUseContext p_196312_1_, EnumFacing p_196312_2_) {
        IBlockState iblockstate = p_196312_1_.func_195991_k().func_180495_p(p_196312_1_.func_195995_a().func_177972_a(p_196312_2_));
        return iblockstate.func_177230_c() == this && iblockstate.func_177229_b((IProperty)field_196314_b) == ChestType.SINGLE ? (EnumFacing)((Object)iblockstate.func_177229_b((IProperty)field_176459_a)) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).func_200226_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)((Object)this));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        ILockableContainer ilockablecontainer = this.func_196309_a(state, worldIn, pos, false);
        if (ilockablecontainer != null) {
            player.func_71007_a((IInventory)ilockablecontainer);
            player.func_71029_a(this.func_196310_d());
        }
        return true;
    }

    protected Stat<ResourceLocation> func_196310_d() {
        return StatList.field_199092_j.func_199076_b((Object)StatList.field_188063_ac);
    }

    @Nullable
    public ILockableContainer func_196309_a(IBlockState state, World worldIn, BlockPos pos, boolean allowBlockedChest) {
        ChestType chesttype1;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityChest)) {
            return null;
        }
        if (!allowBlockedChest && this.func_176457_m(worldIn, pos)) {
            return null;
        }
        TileEntityChest ilockablecontainer = (TileEntityChest)tileentity;
        ChestType chesttype = (ChestType)state.func_177229_b((IProperty)field_196314_b);
        if (chesttype == ChestType.SINGLE) {
            return ilockablecontainer;
        }
        BlockPos blockpos = pos.func_177972_a(BlockChest.func_196311_i(state));
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() == this && (chesttype1 = (ChestType)iblockstate.func_177229_b((IProperty)field_196314_b)) != ChestType.SINGLE && chesttype != chesttype1 && iblockstate.func_177229_b((IProperty)field_176459_a) == state.func_177229_b((IProperty)field_176459_a)) {
            if (!allowBlockedChest && this.func_176457_m(worldIn, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(blockpos);
            if (tileentity1 instanceof TileEntityChest) {
                TileEntityChest ilockablecontainer1 = chesttype == ChestType.RIGHT ? ilockablecontainer : (ILockableContainer)tileentity1;
                TileEntityChest ilockablecontainer2 = chesttype == ChestType.RIGHT ? (ILockableContainer)tileentity1 : ilockablecontainer;
                ilockablecontainer = new InventoryLargeChest((ITextComponent)new TextComponentTranslation("container.chestDouble", new Object[0]), (ILockableContainer)ilockablecontainer1, (ILockableContainer)ilockablecontainer2);
            }
        }
        return ilockablecontainer;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityChest();
    }

    private boolean func_176457_m(World worldIn, BlockPos pos) {
        return this.func_176456_n((IBlockReader)worldIn, pos) || this.func_176453_o(worldIn, pos);
    }

    private boolean func_176456_n(IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening(worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean func_176453_o(World worldIn, BlockPos pos) {
        List<EntityOcelot> list = worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)));
        if (!list.isEmpty()) {
            for (EntityOcelot entityocelot : list) {
                if (!entityocelot.func_70906_o()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.func_196309_a(blockState, worldIn, pos, false));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)field_176459_a, (Comparable)((Object)rot.func_185831_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_176459_a)))));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_176459_a))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176459_a, field_196314_b, field_204511_c});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

