/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEnchantmentTable
extends BlockContainer {
    protected static final VoxelShape field_196322_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);

    protected BlockEnchantmentTable(Block.Properties builder) {
        super(builder);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196322_a;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = pos.func_177982_a(i, k, j);
                    if (!(worldIn.func_180495_p(blockpos).getEnchantPowerBonus(worldIn, pos) > 0.0f)) continue;
                    if (!worldIn.func_175623_d(pos.func_177982_a(i / 2, 0, j / 2))) continue block1;
                    worldIn.func_195594_a((IParticleData)Particles.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (float)k - rand.nextFloat() - 1.0f, (double)((float)j + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityEnchantmentTable();
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityEnchantmentTable) {
            player.func_180468_a((IInteractionObject)((TileEntityEnchantmentTable)tileentity));
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityEnchantmentTable) {
            ((TileEntityEnchantmentTable)tileentity).func_200229_a(stack.func_200301_q());
        }
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

