/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockFenceGate
extends BlockHorizontal {
    public static final BooleanProperty field_176466_a = BlockStateProperties.field_208193_t;
    public static final BooleanProperty field_176465_b = BlockStateProperties.field_208194_u;
    public static final BooleanProperty field_176467_M = BlockStateProperties.field_208189_p;
    protected static final VoxelShape field_185541_d = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape field_185542_e = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);
    protected static final VoxelShape field_185543_f = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 13.0, 10.0);
    protected static final VoxelShape field_185544_g = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 13.0, 16.0);
    protected static final VoxelShape field_208068_x = Block.func_208617_a(0.0, 0.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape field_185540_C = Block.func_208617_a(6.0, 0.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape field_208069_z = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), (VoxelShape)Block.func_208617_a(14.0, 5.0, 7.0, 16.0, 16.0, 9.0));
    protected static final VoxelShape field_185539_B = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a(7.0, 5.0, 0.0, 9.0, 16.0, 2.0), (VoxelShape)Block.func_208617_a(7.0, 5.0, 14.0, 9.0, 16.0, 16.0));
    protected static final VoxelShape field_208066_B = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a(0.0, 2.0, 7.0, 2.0, 13.0, 9.0), (VoxelShape)Block.func_208617_a(14.0, 2.0, 7.0, 16.0, 13.0, 9.0));
    protected static final VoxelShape field_208067_C = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a(7.0, 2.0, 0.0, 9.0, 13.0, 2.0), (VoxelShape)Block.func_208617_a(7.0, 2.0, 14.0, 9.0, 13.0, 16.0));

    public BlockFenceGate(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176466_a, Boolean.valueOf(false))).func_206870_a((IProperty)field_176465_b, Boolean.valueOf(false))).func_206870_a((IProperty)field_176467_M, Boolean.valueOf(false)));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)field_176467_M)).booleanValue()) {
            return ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176740_k() == EnumFacing.Axis.X ? field_185544_g : field_185543_f;
        }
        return ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176740_k() == EnumFacing.Axis.X ? field_185542_e : field_185541_d;
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        EnumFacing.Axis enumfacing$axis = facing.func_176740_k();
        if (((EnumFacing)((Object)stateIn.func_177229_b((IProperty)field_185512_D))).func_176746_e().func_176740_k() != enumfacing$axis) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        boolean flag = this.func_196380_i(facingState) || this.func_196380_i(worldIn.func_180495_p(currentPos.func_177972_a(facing.func_176734_d())));
        return (IBlockState)stateIn.func_206870_a((IProperty)field_176467_M, Boolean.valueOf(flag));
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176740_k() == EnumFacing.Axis.Z ? field_208068_x : field_185540_C;
    }

    public VoxelShape func_196247_c(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)field_176467_M)).booleanValue()) {
            return ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176740_k() == EnumFacing.Axis.X ? field_208067_C : field_208066_B;
        }
        return ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176740_k() == EnumFacing.Axis.X ? field_185539_B : field_208069_z;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)field_176466_a);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)field_176466_a);
            }
        }
        return false;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        boolean flag = world.func_175640_z(blockpos);
        EnumFacing enumfacing = context.func_195992_f();
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        boolean flag1 = enumfacing$axis == EnumFacing.Axis.Z && (this.func_196380_i(world.func_180495_p(blockpos.func_177976_e())) || this.func_196380_i(world.func_180495_p(blockpos.func_177974_f()))) || enumfacing$axis == EnumFacing.Axis.X && (this.func_196380_i(world.func_180495_p(blockpos.func_177978_c())) || this.func_196380_i(world.func_180495_p(blockpos.func_177968_d())));
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)field_176466_a, Boolean.valueOf(flag))).func_206870_a((IProperty)field_176465_b, Boolean.valueOf(flag))).func_206870_a((IProperty)field_176467_M, Boolean.valueOf(flag1));
    }

    private boolean func_196380_i(IBlockState p_196380_1_) {
        return p_196380_1_.func_177230_c() == Blocks.field_150463_bK || p_196380_1_.func_177230_c() == Blocks.field_196723_eg || p_196380_1_.func_177230_c() instanceof BlockWall;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue()) {
            state = (IBlockState)state.func_206870_a((IProperty)field_176466_a, Boolean.valueOf(false));
            worldIn.func_180501_a(pos, state, 10);
        } else {
            EnumFacing enumfacing = player.func_174811_aO();
            if (state.func_177229_b((IProperty)field_185512_D) == enumfacing.func_176734_d()) {
                state = (IBlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)((Object)enumfacing));
            }
            state = (IBlockState)state.func_206870_a((IProperty)field_176466_a, Boolean.valueOf(true));
            worldIn.func_180501_a(pos, state, 10);
        }
        worldIn.func_180498_a(player, (Boolean)state.func_177229_b((IProperty)field_176466_a) != false ? 1008 : 1014, pos, 0);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            boolean flag = worldIn.func_175640_z(pos);
            if ((Boolean)state.func_177229_b((IProperty)field_176465_b) != flag) {
                worldIn.func_180501_a(pos, (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176465_b, Boolean.valueOf(flag))).func_206870_a((IProperty)field_176466_a, Boolean.valueOf(flag)), 2);
                if ((Boolean)state.func_177229_b((IProperty)field_176466_a) != flag) {
                    worldIn.func_180498_a(null, flag ? 1008 : 1014, pos, 0);
                }
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176466_a, field_176465_b, field_176467_M});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face != EnumFacing.UP && face != EnumFacing.DOWN) {
            return ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))).func_176740_k() == face.func_176746_e().func_176740_k() ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        if (state.func_193401_d(world, pos, facing) == BlockFaceShape.MIDDLE_POLE) {
            Block other = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
            return other instanceof BlockFence || other instanceof BlockWall;
        }
        return false;
    }
}

