/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockNetherWart
extends BlockBush {
    public static final IntegerProperty field_176486_a = BlockStateProperties.field_208168_U;
    private static final VoxelShape[] field_196399_b = new VoxelShape[]{Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 5.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 11.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0)};

    protected BlockNetherWart(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176486_a, Integer.valueOf(0)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196399_b[(Integer)state.func_177229_b((IProperty)field_176486_a)];
    }

    @Override
    protected boolean func_200014_a_(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150425_aM;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((IProperty)field_176486_a);
        if (i < 3 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            state = (IBlockState)state.func_206870_a((IProperty)field_176486_a, Integer.valueOf(i + 1));
            worldIn.func_180501_a(pos, state, 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state);
        }
        super.func_196267_b(state, worldIn, pos, random);
    }

    @Override
    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, chancePerItem, fortune);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World worldIn, BlockPos pos, int fortune) {
        int i = 1;
        if ((Integer)state.func_177229_b((IProperty)field_176486_a) >= 3) {
            i = 2 + worldIn.field_73012_v.nextInt(3);
            if (fortune > 0) {
                i += worldIn.field_73012_v.nextInt(fortune + 1);
            }
        }
        for (int j = 0; j < i; ++j) {
            drops.add((Object)new ItemStack(Items.field_151075_bm));
        }
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.field_151075_bm);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176486_a});
    }
}

