/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockPistonBase
extends BlockDirectional {
    public static final BooleanProperty field_176320_b = BlockStateProperties.field_208181_h;
    protected static final VoxelShape field_185648_b = Block.func_208617_a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape field_185649_c = Block.func_208617_a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185650_d = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape field_185651_e = Block.func_208617_a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185652_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape field_185653_g = Block.func_208617_a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean field_150082_a;

    public BlockPistonBase(boolean sticky, Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176387_N, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)field_176320_b, Boolean.valueOf(false)));
        this.field_150082_a = sticky;
    }

    public boolean func_176214_u(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) == false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            switch ((EnumFacing)((Object)state.func_177229_b((IProperty)field_176387_N))) {
                case DOWN: {
                    return field_185653_g;
                }
                default: {
                    return field_185652_f;
                }
                case NORTH: {
                    return field_185651_e;
                }
                case SOUTH: {
                    return field_185650_d;
                }
                case WEST: {
                    return field_185649_c;
                }
                case EAST: 
            }
            return field_185648_b;
        }
        return VoxelShapes.func_197868_b();
    }

    public boolean func_185481_k(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) == false || state.func_177229_b((IProperty)field_176387_N) == EnumFacing.DOWN;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            this.func_176316_e(worldIn, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            this.func_176316_e(worldIn, pos, state);
        }
    }

    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            this.func_176316_e(worldIn, pos, state);
        }
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)((Object)context.func_196010_d().func_176734_d()))).func_206870_a((IProperty)field_176320_b, Boolean.valueOf(false));
    }

    private void func_176316_e(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_176387_N));
        boolean flag = this.func_176318_b(worldIn, pos, enumfacing);
        if (flag && !((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            if (new BlockPistonStructureHelper(worldIn, pos, enumfacing, true).func_177253_a()) {
                worldIn.func_175641_c(pos, (Block)((Object)this), 0, enumfacing.func_176745_a());
            }
        } else if (!flag && ((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            TileEntityPiston tileentitypiston;
            TileEntity tileentity;
            BlockPos blockpos = pos.func_177967_a(enumfacing, 2);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            int i = 1;
            if (iblockstate.func_177230_c() == Blocks.field_196603_bb && iblockstate.func_177229_b((IProperty)field_176387_N) == enumfacing && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).func_145868_b() && (tileentitypiston.func_145860_a(0.0f) < 0.5f || worldIn.func_82737_E() == tileentitypiston.func_211146_k() || ((WorldServer)worldIn).func_211158_j_())) {
                i = 2;
            }
            worldIn.func_175641_c(pos, (Block)((Object)this), i, enumfacing.func_176745_a());
        }
    }

    private boolean func_176318_b(World worldIn, BlockPos pos, EnumFacing facing) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing == facing || !worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
            return true;
        }
        if (worldIn.func_175709_b(pos, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.func_177984_a();
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            if (enumfacing1 == EnumFacing.DOWN || !worldIn.func_175709_b(blockpos.func_177972_a(enumfacing1), enumfacing1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_176387_N));
        if (!worldIn.field_72995_K) {
            boolean flag = this.func_176318_b(worldIn, pos, enumfacing);
            if (flag && (id == 1 || id == 2)) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176320_b, Boolean.valueOf(true)), 2);
                return false;
            }
            if (!flag && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.func_176319_a(worldIn, pos, enumfacing, true)) {
                return false;
            }
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176320_b, Boolean.valueOf(true)), 67);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1 || id == 2) {
            TileEntity tileentity1 = worldIn.func_175625_s(pos.func_177972_a(enumfacing));
            if (tileentity1 instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity1).func_145866_f();
            }
            worldIn.func_180501_a(pos, (IBlockState)((IBlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a((IProperty)BlockPistonMoving.field_196344_a, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)BlockPistonMoving.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT)), 3);
            worldIn.func_175690_a(pos, BlockPistonMoving.func_196343_a((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)((Object)EnumFacing.func_82600_a(param & 7))), enumfacing, false, true));
            if (this.field_150082_a) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity;
                BlockPos blockpos = pos.func_177982_a(enumfacing.func_82601_c() * 2, enumfacing.func_96559_d() * 2, enumfacing.func_82599_e() * 2);
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                boolean flag1 = false;
                if (block == Blocks.field_196603_bb && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).func_212363_d() == enumfacing && tileentitypiston.func_145868_b()) {
                    tileentitypiston.func_145866_f();
                    flag1 = true;
                }
                if (!flag1) {
                    if (id != 1 || iblockstate.func_196958_f() || !BlockPistonBase.func_185646_a(iblockstate, worldIn, blockpos, enumfacing.func_176734_d(), false, enumfacing) || iblockstate.func_185905_o() != EnumPushReaction.NORMAL && block != Blocks.field_150331_J && block != Blocks.field_150320_F) {
                        worldIn.func_175698_g(pos.func_177972_a(enumfacing));
                    } else {
                        this.func_176319_a(worldIn, pos, enumfacing, false);
                    }
                }
            } else {
                worldIn.func_175698_g(pos.func_177972_a(enumfacing));
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static boolean func_185646_a(IBlockState blockStateIn, World worldIn, BlockPos pos, EnumFacing facing, boolean destroyBlocks, EnumFacing p_185646_5_) {
        Block block = blockStateIn.func_177230_c();
        if (block == Blocks.field_150343_Z) {
            return false;
        }
        if (!worldIn.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (pos.func_177956_o() >= 0 && (facing != EnumFacing.DOWN || pos.func_177956_o() != 0)) {
            if (pos.func_177956_o() <= worldIn.func_72800_K() - 1 && (facing != EnumFacing.UP || pos.func_177956_o() != worldIn.func_72800_K() - 1)) {
                if (block != Blocks.field_150331_J && block != Blocks.field_150320_F) {
                    if (blockStateIn.func_185887_b((IBlockReader)worldIn, pos) == -1.0f) {
                        return false;
                    }
                    switch (blockStateIn.func_185905_o()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == p_185646_5_;
                        }
                    }
                } else if (((Boolean)blockStateIn.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
                    return false;
                }
                return !blockStateIn.hasTileEntity();
            }
            return false;
        }
        return false;
    }

    private boolean func_176319_a(World worldIn, BlockPos pos, EnumFacing direction, boolean extending) {
        BlockPistonStructureHelper blockpistonstructurehelper;
        BlockPos blockpos = pos.func_177972_a(direction);
        if (!extending && worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150332_K) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(blockpistonstructurehelper = new BlockPistonStructureHelper(worldIn, pos, direction, extending)).func_177253_a()) {
            return false;
        }
        List<BlockPos> list = blockpistonstructurehelper.func_177254_c();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = list.get(i);
            list1.add(worldIn.func_180495_p(blockpos1));
        }
        List<BlockPos> list2 = blockpistonstructurehelper.func_177252_d();
        int k = list.size() + list2.size();
        IBlockState[] aiblockstate = new IBlockState[k];
        EnumFacing enumfacing = extending ? direction : direction.func_176734_d();
        HashSet set = Sets.newHashSet(list);
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos2 = list2.get(j);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos2);
            float chance = iblockstate.func_177230_c() instanceof BlockSnow ? -1.0f : 1.0f;
            iblockstate.func_196941_a(worldIn, blockpos2, chance, 0);
            worldIn.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 18);
            aiblockstate[--k] = iblockstate;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            IBlockState iblockstate3 = worldIn.func_180495_p(blockpos3);
            blockpos3 = blockpos3.func_177972_a(enumfacing);
            set.remove(blockpos3);
            worldIn.func_180501_a(blockpos3, (IBlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)((Object)direction)), 68);
            worldIn.func_175690_a(blockpos3, BlockPistonMoving.func_196343_a((IBlockState)list1.get(l), direction, extending, false));
            aiblockstate[--k] = iblockstate3;
        }
        if (extending) {
            PistonType pistontype = this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT;
            IBlockState iblockstate1 = (IBlockState)((IBlockState)Blocks.field_150332_K.func_176223_P().func_206870_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)((Object)direction))).func_206870_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)pistontype);
            IBlockState iblockstate4 = (IBlockState)((IBlockState)Blocks.field_196603_bb.func_176223_P().func_206870_a((IProperty)BlockPistonMoving.field_196344_a, (Comparable)((Object)direction))).func_206870_a((IProperty)BlockPistonMoving.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT));
            set.remove(blockpos);
            worldIn.func_180501_a(blockpos, iblockstate4, 68);
            worldIn.func_175690_a(blockpos, BlockPistonMoving.func_196343_a(iblockstate1, direction, true, true));
        }
        for (BlockPos blockpos4 : set) {
            worldIn.func_180501_a(blockpos4, Blocks.field_150350_a.func_176223_P(), 66);
        }
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            IBlockState iblockstate2 = aiblockstate[k++];
            BlockPos blockpos5 = list2.get(i1);
            iblockstate2.func_196948_b(worldIn, blockpos5, 2);
            worldIn.func_195593_d(blockpos5, iblockstate2.func_177230_c());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            worldIn.func_195593_d(list.get(j1), aiblockstate[k++].func_177230_c());
        }
        if (extending) {
            worldIn.func_195593_d(blockpos, Blocks.field_150332_K);
        }
        return true;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)((Object)rot.func_185831_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_176387_N)))));
    }

    public IBlockState rotate(IBlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (Boolean)state.func_177229_b((IProperty)field_176320_b) != false ? state : super.rotate(state, world, pos, direction);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_176387_N))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N, field_176320_b});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return state.func_177229_b((IProperty)field_176387_N) != face.func_176734_d() && (Boolean)state.func_177229_b((IProperty)field_176320_b) != false ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

