/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockRailDetector
extends BlockRailBase {
    public static final EnumProperty<RailShape> field_176573_b = BlockStateProperties.field_208166_S;
    public static final BooleanProperty field_176574_M = BlockStateProperties.field_208194_u;

    public BlockRailDetector(Block.Properties builder) {
        super(true, builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176574_M, Boolean.valueOf(false))).func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_SOUTH));
    }

    @Override
    public int func_149738_a(IWorldReaderBase worldIn) {
        return 20;
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public void func_196262_a(IBlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && !((Boolean)state.func_177229_b((IProperty)field_176574_M)).booleanValue()) {
            this.func_176570_e(worldIn, pos, state);
        }
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176574_M)).booleanValue()) {
            this.func_176570_e(worldIn, pos, state);
        }
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)field_176574_M) != false ? 15 : 0;
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)field_176574_M)).booleanValue()) {
            return 0;
        }
        return side == EnumFacing.UP ? 15 : 0;
    }

    private void func_176570_e(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag = (Boolean)state.func_177229_b((IProperty)field_176574_M);
        boolean flag1 = false;
        List<EntityMinecart> list = this.func_200878_a(worldIn, pos, EntityMinecart.class, null);
        if (!list.isEmpty()) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176574_M, Boolean.valueOf(true)), 3);
            this.func_185592_b(worldIn, pos, state, true);
            worldIn.func_195593_d(pos, this);
            worldIn.func_195593_d(pos.func_177977_b(), this);
            worldIn.func_175704_b(pos, pos);
        }
        if (!flag1 && flag) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176574_M, Boolean.valueOf(false)), 3);
            this.func_185592_b(worldIn, pos, state, false);
            worldIn.func_195593_d(pos, this);
            worldIn.func_195593_d(pos.func_177977_b(), this);
            worldIn.func_175704_b(pos, pos);
        }
        if (flag1) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a(worldIn));
        }
        worldIn.func_175666_e(pos, this);
    }

    protected void func_185592_b(World worldIn, BlockPos pos, IBlockState state, boolean powered) {
        BlockRailState blockrailstate = new BlockRailState(worldIn, pos, state);
        for (BlockPos blockpos : blockrailstate.func_196907_a()) {
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            iblockstate.func_189546_a(worldIn, blockpos, iblockstate.func_177230_c(), pos);
        }
    }

    @Override
    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            super.func_196259_b(state, worldIn, pos, oldState);
            this.func_176570_e(worldIn, pos, state);
        }
    }

    @Override
    public IProperty<RailShape> func_176560_l() {
        return field_176573_b;
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)field_176574_M)).booleanValue()) {
            List<EntityMinecart> carts = this.func_200878_a(worldIn, pos, EntityMinecart.class, null);
            if (!carts.isEmpty() && carts.get(0).getComparatorLevel() > -1) {
                return carts.get(0).getComparatorLevel();
            }
            List<EntityMinecartCommandBlock> list = this.func_200878_a(worldIn, pos, EntityMinecartCommandBlock.class, null);
            if (!list.isEmpty()) {
                return list.get(0).func_145822_e().func_145760_g();
            }
            List<EntityMinecart> list1 = this.func_200878_a(worldIn, pos, EntityMinecart.class, EntitySelectors.field_96566_b);
            if (!list1.isEmpty()) {
                return Container.func_94526_b((IInventory)list1.get(0));
            }
        }
        return 0;
    }

    protected <T extends EntityMinecart> List<T> func_200878_a(World p_200878_1_, BlockPos p_200878_2_, Class<T> p_200878_3_, @Nullable Predicate<Entity> p_200878_4_) {
        return p_200878_1_.func_175647_a(p_200878_3_, this.func_176572_a(p_200878_2_), p_200878_4_);
    }

    private AxisAlignedBB func_176572_a(BlockPos pos) {
        float f = 0.2f;
        return new AxisAlignedBB((double)((float)pos.func_177958_n() + 0.2f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.2f), (double)((float)(pos.func_177958_n() + 1) - 0.2f), (double)((float)(pos.func_177956_o() + 1) - 0.2f), (double)((float)(pos.func_177952_p() + 1) - 0.2f));
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.func_177229_b((IProperty)field_176573_b)) {
                    case ASCENDING_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b((IProperty)field_176573_b)) {
                    case ASCENDING_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.func_177229_b((IProperty)field_176573_b)) {
                    case ASCENDING_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.func_177229_b((IProperty)field_176573_b);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.func_185471_a(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (IBlockState)state.func_206870_a((IProperty)field_176573_b, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176573_b, field_176574_M});
    }
}

