/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;

public class BlockRedstoneComparator
extends BlockRedstoneDiode
implements ITileEntityProvider {
    public static final EnumProperty<ComparatorMode> field_176463_b = BlockStateProperties.field_208141_ap;

    public BlockRedstoneComparator(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)field_196348_c, Boolean.valueOf(false))).func_206870_a((IProperty)field_176463_b, (Comparable)ComparatorMode.COMPARE));
    }

    @Override
    protected int func_196346_i(IBlockState p_196346_1_) {
        return 2;
    }

    @Override
    protected int func_176408_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).func_145996_a() : 0;
    }

    private int func_176460_j(World worldIn, BlockPos pos, IBlockState state) {
        return state.func_177229_b((IProperty)field_176463_b) == ComparatorMode.SUBTRACT ? Math.max(this.func_176397_f(worldIn, pos, state) - this.func_176407_c(worldIn, pos, state), 0) : this.func_176397_f(worldIn, pos, state);
    }

    @Override
    protected boolean func_176404_e(World worldIn, BlockPos pos, IBlockState state) {
        int i = this.func_176397_f(worldIn, pos, state);
        if (i >= 15) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        return i >= this.func_176407_c(worldIn, pos, state);
    }

    @Override
    protected void func_211326_a(World p_211326_1_, BlockPos p_211326_2_) {
        p_211326_1_.func_175713_t(p_211326_2_);
    }

    @Override
    protected int func_176397_f(World worldIn, BlockPos pos, IBlockState state) {
        int i = super.func_176397_f(worldIn, pos, state);
        EnumFacing enumfacing = (EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D));
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_185912_n()) {
            i = iblockstate.func_185888_a(worldIn, blockpos);
        } else if (i < 15 && iblockstate.func_185915_l()) {
            EntityItemFrame entityitemframe;
            iblockstate = worldIn.func_180495_p(blockpos = blockpos.func_177972_a(enumfacing));
            if (iblockstate.func_185912_n()) {
                i = iblockstate.func_185888_a(worldIn, blockpos);
            } else if (iblockstate.func_196958_f() && (entityitemframe = this.func_176461_a(worldIn, enumfacing, blockpos)) != null) {
                i = entityitemframe.func_174866_q();
            }
        }
        return i;
    }

    @Nullable
    private EntityItemFrame func_176461_a(World worldIn, EnumFacing facing, BlockPos pos) {
        List<EntityItemFrame> list = worldIn.func_175647_a(EntityItemFrame.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), p_210304_1_ -> p_210304_1_ != null && p_210304_1_.func_174811_aO() == facing);
        return list.size() == 1 ? list.get(0) : null;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.field_71075_bZ.field_75099_e) {
            return false;
        }
        float f = (state = (IBlockState)state.func_177231_a((IProperty)field_176463_b)).func_177229_b((IProperty)field_176463_b) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        worldIn.func_184133_a(player, pos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_180501_a(pos, state, 2);
        this.func_176462_k(worldIn, pos, state);
        return true;
    }

    @Override
    protected void func_176398_g(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            int j;
            int i = this.func_176460_j(worldIn, pos, state);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            int n = j = tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).func_145996_a() : 0;
            if (i != j || ((Boolean)state.func_177229_b((IProperty)field_196348_c)).booleanValue() != this.func_176404_e(worldIn, pos, state)) {
                TickPriority tickpriority = this.func_176402_i((IBlockReader)worldIn, pos, state) ? TickPriority.HIGH : TickPriority.NORMAL;
                worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, tickpriority);
            }
        }
    }

    private void func_176462_k(World worldIn, BlockPos pos, IBlockState state) {
        int i = this.func_176460_j(worldIn, pos, state);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        int j = 0;
        if (tileentity instanceof TileEntityComparator) {
            TileEntityComparator tileentitycomparator = (TileEntityComparator)tileentity;
            j = tileentitycomparator.func_145996_a();
            tileentitycomparator.func_145995_a(i);
        }
        if (j != i || state.func_177229_b((IProperty)field_176463_b) == ComparatorMode.COMPARE) {
            boolean flag1 = this.func_176404_e(worldIn, pos, state);
            boolean flag = (Boolean)state.func_177229_b((IProperty)field_196348_c);
            if (flag && !flag1) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(false)), 2);
            } else if (!flag && flag1) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(true)), 2);
            }
            this.func_176400_h(worldIn, pos, state);
        }
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        this.func_176462_k(worldIn, pos, state);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityComparator();
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176463_b, field_196348_c});
    }

    public boolean getWeakChanges(IBlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public void onNeighborChange(IBlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177956_o() == neighbor.func_177956_o() && world instanceof World && !((World)world).func_201670_d()) {
            this.func_189540_a(state, (World)world, pos, world.func_180495_p(neighbor).func_177230_c(), neighbor);
        }
    }
}

