/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStemGrown;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockStem
extends BlockBush
implements IGrowable {
    public static final IntegerProperty field_176484_a = BlockStateProperties.field_208170_W;
    protected static final VoxelShape[] field_196388_b = new VoxelShape[]{Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.func_208617_a(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final BlockStemGrown field_149877_a;

    protected BlockStem(BlockStemGrown p_i48318_1_, Block.Properties p_i48318_2_) {
        super(p_i48318_2_);
        this.field_149877_a = p_i48318_1_;
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176484_a, Integer.valueOf(0)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196388_b[(Integer)state.func_177229_b((IProperty)field_176484_a)];
    }

    @Override
    protected boolean func_200014_a_(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        float f;
        super.func_196267_b(state, worldIn, pos, random);
        if (!worldIn.func_205050_e(pos, 1)) {
            return;
        }
        if (worldIn.func_201669_a(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (random.nextInt((int)(25.0f / (f = BlockCrops.func_180672_a(this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)state.func_177229_b((IProperty)field_176484_a);
            if (i < 7) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176484_a, Integer.valueOf(i + 1)), 2);
            } else {
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos blockpos = pos.func_177972_a(enumfacing);
                IBlockState soil = worldIn.func_180495_p(blockpos.func_177977_b());
                Block block = soil.func_177230_c();
                if (worldIn.func_180495_p(blockpos).isAir((IBlockReader)worldIn, blockpos) && (soil.canSustainPlant((IBlockReader)worldIn, blockpos.func_177977_b(), EnumFacing.UP, this) || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_196658_i)) {
                    worldIn.func_175656_a(blockpos, this.field_149877_a.func_176223_P());
                    worldIn.func_175656_a(pos, (IBlockState)this.field_149877_a.func_196523_e().func_176223_P().func_206870_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)((Object)enumfacing)));
                }
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state);
        }
    }

    @Override
    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, chancePerItem, fortune);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        Item item = this.func_176481_j();
        if (item != null) {
            int i = (Integer)state.func_177229_b((IProperty)field_176484_a);
            for (int j = 0; j < 3; ++j) {
                if (world.field_73012_v.nextInt(15) > i) continue;
                drops.add((Object)new ItemStack(item));
            }
        }
    }

    @Nullable
    protected Item func_176481_j() {
        if (this.field_149877_a == Blocks.field_150423_aK) {
            return Items.field_151080_bb;
        }
        return this.field_149877_a == Blocks.field_150440_ba ? Items.field_151081_bc : null;
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        Item item = this.func_176481_j();
        return item == null ? ItemStack.field_190927_a : new ItemStack(item);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)field_176484_a) != 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int i = Math.min(7, (Integer)state.func_177229_b((IProperty)field_176484_a) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5));
        IBlockState iblockstate = (IBlockState)state.func_206870_a((IProperty)field_176484_a, Integer.valueOf(i));
        worldIn.func_180501_a(pos, iblockstate, 2);
        if (i == 7) {
            iblockstate.func_196940_a(worldIn, pos, worldIn.field_73012_v);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176484_a});
    }

    public BlockStemGrown func_208486_d() {
        return this.field_149877_a;
    }
}

