/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ITickable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressManager;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SoundHandler
implements ITickable,
IResourceManagerReloadListener {
    public static final Sound field_147700_a = new Sound("meta:missing_sound", 1.0f, 1.0f, 1, Sound.Type.FILE, false, false, 16);
    private static final Logger field_147698_b = LogManager.getLogger();
    private static final Gson field_147699_c = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static final ParameterizedType field_147696_d = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundList.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };
    private final Map<ResourceLocation, SoundEventAccessor> field_147697_e = Maps.newHashMap();
    private final SoundManager field_147694_f;
    private final IResourceManager field_147695_g;

    public SoundHandler(IResourceManager manager, GameSettings gameSettingsIn) {
        this.field_147695_g = manager;
        this.field_147694_f = new SoundManager(this, gameSettingsIn);
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_147697_e.clear();
        LinkedList<Tuple> resources = new LinkedList<Tuple>();
        for (String string : resourceManager.func_199001_a()) {
            try {
                for (IResource iresource : resourceManager.func_199004_b(new ResourceLocation(string, "sounds.json"))) {
                    try {
                        Map<String, SoundList> map = this.func_175085_a(iresource.func_199027_b());
                        for (Map.Entry<String, SoundList> entry2 : map.entrySet()) {
                            resources.add(new Tuple((Object)new ResourceLocation(string, entry2.getKey()), (Object)entry2.getValue()));
                        }
                    }
                    catch (RuntimeException runtimeexception) {
                        field_147698_b.warn("Invalid sounds.json in resourcepack: '{}'", (Object)iresource.func_199026_d(), (Object)runtimeexception);
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        Throwable throwable = null;
        try (ProgressBar resourcesBar = StartupProgressManager.start((String)"Loading sounds", (int)resources.size());){
            resources.forEach(entry -> {
                resourcesBar.step(((ResourceLocation)entry.func_76341_a()).toString());
                try {
                    this.func_147693_a((ResourceLocation)entry.func_76341_a(), (SoundList)entry.func_76340_b());
                }
                catch (RuntimeException e) {
                    field_147698_b.warn("Invalid sounds.json", (Throwable)e);
                }
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (ResourceLocation resourceLocation : this.field_147697_e.keySet()) {
            String s1;
            SoundEventAccessor soundeventaccessor = this.field_147697_e.get(resourceLocation);
            if (!(soundeventaccessor.func_188712_c() instanceof TextComponentTranslation) || I18n.func_188566_a(s1 = ((TextComponentTranslation)soundeventaccessor.func_188712_c()).func_150268_i())) continue;
            field_147698_b.debug("Missing subtitle {} for event: {}", (Object)s1, (Object)resourceLocation);
        }
        for (ResourceLocation resourceLocation : this.field_147697_e.keySet()) {
            if (IRegistry.field_212633_v.func_212608_b(resourceLocation) != null) continue;
            field_147698_b.debug("Not having sound event for: {}", (Object)resourceLocation);
        }
        this.field_147694_f.func_148596_a();
    }

    @Nullable
    protected Map<String, SoundList> func_175085_a(InputStream stream) {
        Map map;
        try {
            map = (Map)JsonUtils.func_193841_a((Gson)field_147699_c, (Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (Type)field_147696_d);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return map;
    }

    private void func_147693_a(ResourceLocation location, SoundList sounds) {
        boolean flag;
        SoundEventAccessor soundeventaccessor = this.field_147697_e.get(location);
        boolean bl = flag = soundeventaccessor == null;
        if (flag || sounds.func_148574_b()) {
            if (!flag) {
                field_147698_b.debug("Replaced sound event location {}", (Object)location);
            }
            soundeventaccessor = new SoundEventAccessor(location, sounds.func_188701_c());
            this.field_147697_e.put(location, soundeventaccessor);
        }
        block4: for (final Sound sound : sounds.func_188700_a()) {
            Object isoundeventaccessor;
            final ResourceLocation resourcelocation = sound.func_188719_a();
            switch (sound.func_188722_g()) {
                case FILE: {
                    if (!this.func_184401_a(sound, location)) continue block4;
                    isoundeventaccessor = sound;
                    break;
                }
                case SOUND_EVENT: {
                    isoundeventaccessor = new ISoundEventAccessor<Sound>(){

                        public int func_148721_a() {
                            SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)SoundHandler.this.field_147697_e.get(resourcelocation);
                            return soundeventaccessor1 == null ? 0 : soundeventaccessor1.func_148721_a();
                        }

                        public Sound func_148720_g() {
                            SoundEventAccessor soundeventaccessor1 = (SoundEventAccessor)SoundHandler.this.field_147697_e.get(resourcelocation);
                            if (soundeventaccessor1 == null) {
                                return field_147700_a;
                            }
                            Sound sound1 = soundeventaccessor1.func_148720_g();
                            return new Sound(sound1.func_188719_a().toString(), sound1.func_188724_c() * sound.func_188724_c(), sound1.func_188725_d() * sound.func_188725_d(), sound.func_148721_a(), Sound.Type.FILE, sound1.func_188723_h() || sound.func_188723_h(), sound1.func_204257_i(), sound1.func_206255_j());
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SoundEventRegistration type: " + sound.func_188722_g());
                }
            }
            if (((Sound)isoundeventaccessor.func_148720_g()).func_204257_i()) {
                this.field_147694_f.func_204259_a((Sound)isoundeventaccessor.func_148720_g());
            }
            soundeventaccessor.func_188715_a((ISoundEventAccessor)isoundeventaccessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean func_184401_a(Sound soundIn, ResourceLocation p_184401_2_) {
        boolean flag;
        boolean bl;
        ResourceLocation resourcelocation = soundIn.func_188721_b();
        IResource iresource = null;
        try {
            iresource = this.field_147695_g.func_199002_a(resourcelocation);
            iresource.func_199027_b();
            bl = true;
        }
        catch (FileNotFoundException var11) {
            field_147698_b.warn("File {} does not exist, cannot add it to event {}", (Object)resourcelocation, (Object)p_184401_2_);
            flag = false;
            IOUtils.closeQuietly((Closeable)iresource);
        }
        catch (IOException ioexception) {
            boolean flag2;
            field_147698_b.warn("Could not load sound file {}, cannot add it to event {}", (Object)resourcelocation, (Object)p_184401_2_, (Object)ioexception);
            boolean bl2 = flag2 = false;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iresource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)iresource);
            return bl2;
        }
        IOUtils.closeQuietly((Closeable)iresource);
        return bl;
        return flag;
    }

    @Nullable
    public SoundEventAccessor func_184398_a(ResourceLocation location) {
        return this.field_147697_e.get(location);
    }

    public Collection<ResourceLocation> func_195477_a() {
        return this.field_147697_e.keySet();
    }

    public void func_147682_a(ISound sound) {
        this.field_147694_f.func_148611_c(sound);
    }

    public void func_147681_a(ISound sound, int delay) {
        this.field_147694_f.func_148599_a(sound, delay);
    }

    public void func_147691_a(EntityPlayer player, float partialTicks) {
        this.field_147694_f.func_148615_a(player, partialTicks);
    }

    public void setListener(Entity entity, float partialTicks) {
        this.field_147694_f.setListener(entity, partialTicks);
    }

    public void func_147689_b() {
        this.field_147694_f.func_148610_e();
    }

    public void func_147690_c() {
        this.field_147694_f.func_148614_c();
    }

    public void func_147685_d() {
        this.field_147694_f.func_148613_b();
    }

    public void func_73660_a() {
        this.field_147694_f.func_148605_d();
    }

    public void func_147687_e() {
        this.field_147694_f.func_148604_f();
    }

    public void func_184399_a(SoundCategory category, float volume) {
        if (category == SoundCategory.MASTER && volume <= 0.0f) {
            this.func_147690_c();
        }
        this.field_147694_f.func_188771_a(category, volume);
    }

    public void func_147683_b(ISound soundIn) {
        this.field_147694_f.func_148602_b(soundIn);
    }

    public boolean func_147692_c(ISound sound) {
        return this.field_147694_f.func_148597_a(sound);
    }

    public void func_184402_a(ISoundEventListener listener) {
        this.field_147694_f.func_188774_a(listener);
    }

    public void func_184400_b(ISoundEventListener listener) {
        this.field_147694_f.func_188773_b(listener);
    }

    public void func_195478_a(@Nullable ResourceLocation id, @Nullable SoundCategory category) {
        this.field_147694_f.func_195855_a(id, category);
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.SOUNDS;
    }
}

