/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSoundMinecart;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveDataMemoryStorage;
import net.minecraft.world.storage.SaveHandlerMP;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class WorldClient
extends World {
    private final NetHandlerPlayClient field_73035_a;
    private ChunkProviderClient field_73033_b;
    private final Set<Entity> field_73032_d = Sets.newHashSet();
    private final Set<Entity> field_73036_L = Sets.newHashSet();
    private final Minecraft field_73037_M = Minecraft.func_71410_x();
    private final Set<ChunkPos> field_73038_N = Sets.newHashSet();
    private int field_184158_M = this.field_73012_v.nextInt(12000);
    protected Set<ChunkPos> field_184157_a = Sets.newHashSet();
    private Scoreboard field_200261_M = new Scoreboard();

    public WorldClient(NetHandlerPlayClient p_i49845_1_, WorldSettings p_i49845_2_, DimensionType p_i49845_3_, EnumDifficulty p_i49845_4_, Profiler p_i49845_5_) {
        super((ISaveHandler)new SaveHandlerMP(), (WorldSavedDataStorage)new SaveDataMemoryStorage(), new WorldInfo(p_i49845_2_, "MpServer"), p_i49845_3_.func_186070_d(), p_i49845_5_, true);
        this.field_73035_a = p_i49845_1_;
        this.func_72912_H().func_176144_a(p_i49845_4_);
        this.field_73011_w.func_76558_a(this);
        this.func_175652_B(new BlockPos(8, 64, 8));
        this.field_73020_y = this.func_72970_h();
        this.func_72966_v();
        this.func_72947_a();
        this.initCapabilities();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)this));
    }

    @Override
    public void func_72835_b(BooleanSupplier p_72835_1_) {
        super.func_72835_b(p_72835_1_);
        this.func_82738_a(this.func_82737_E() + 1L);
        if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
            this.func_72877_b(this.func_72820_D() + 1L);
        }
        this.field_72984_F.func_76320_a("reEntryProcessing");
        for (int i = 0; i < 10 && !this.field_73036_L.isEmpty(); ++i) {
            Entity entity = this.field_73036_L.iterator().next();
            this.field_73036_L.remove((Object)entity);
            if (this.field_72996_f.contains((Object)entity)) continue;
            this.func_72838_d(entity);
        }
        this.field_72984_F.func_76318_c("chunkCache");
        this.field_73033_b.func_73156_b(p_72835_1_);
        this.field_72984_F.func_76318_c("blocks");
        this.func_147456_g();
        this.field_72984_F.func_76319_b();
    }

    @Override
    protected IChunkProvider func_72970_h() {
        this.field_73033_b = new ChunkProviderClient(this);
        return this.field_73033_b;
    }

    public boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return allowEmpty || this.func_72863_F().func_186025_d(x, z, true, false) != null;
    }

    protected void func_184154_a() {
        this.field_184157_a.clear();
        int i = this.field_73037_M.field_71474_y.field_151451_c;
        this.field_72984_F.func_76320_a("buildList");
        int j = MathHelper.func_76128_c((double)(this.field_73037_M.field_71439_g.field_70165_t / 16.0));
        int k = MathHelper.func_76128_c((double)(this.field_73037_M.field_71439_g.field_70161_v / 16.0));
        for (int l = -i; l <= i; ++l) {
            for (int i1 = -i; i1 <= i; ++i1) {
                this.field_184157_a.add(new ChunkPos(l + j, i1 + k));
            }
        }
        this.field_72984_F.func_76319_b();
    }

    @Override
    protected void func_147456_g() {
        this.func_184154_a();
        if (this.field_184158_M > 0) {
            --this.field_184158_M;
        }
        this.field_73038_N.retainAll(this.field_184157_a);
        if (this.field_73038_N.size() == this.field_184157_a.size()) {
            this.field_73038_N.clear();
        }
        int i = 0;
        for (ChunkPos chunkpos : this.field_184157_a) {
            if (this.field_73038_N.contains(chunkpos)) continue;
            int j = chunkpos.field_77276_a * 16;
            int k = chunkpos.field_77275_b * 16;
            this.field_72984_F.func_76320_a("getChunk");
            Chunk chunk = this.func_72964_e(chunkpos.field_77276_a, chunkpos.field_77275_b);
            this.func_147467_a(j, k, chunk);
            this.field_72984_F.func_76319_b();
            this.field_73038_N.add(chunkpos);
            if (++i < 10) continue;
            return;
        }
    }

    @Override
    public boolean func_72838_d(Entity entityIn) {
        boolean flag = super.func_72838_d(entityIn);
        this.field_73032_d.add(entityIn);
        if (flag) {
            if (entityIn instanceof EntityMinecart) {
                this.field_73037_M.func_147118_V().func_147682_a((ISound)new MovingSoundMinecart((EntityMinecart)entityIn));
            }
        } else {
            this.field_73036_L.add(entityIn);
        }
        return flag;
    }

    @Override
    public void func_72900_e(Entity entityIn) {
        super.func_72900_e(entityIn);
    }

    @Override
    public void removeEntity(Entity entityIn, boolean keepData) {
        super.removeEntity(entityIn, keepData);
        this.field_73032_d.remove((Object)entityIn);
    }

    @Override
    public void func_72923_a(Entity entityIn) {
        super.func_72923_a(entityIn);
        if (this.field_73036_L.contains((Object)entityIn)) {
            this.field_73036_L.remove((Object)entityIn);
        }
    }

    @Override
    public void func_72847_b(Entity entityIn) {
        super.func_72847_b(entityIn);
        if (this.field_73032_d.contains((Object)entityIn)) {
            if (entityIn.func_70089_S()) {
                this.field_73036_L.add(entityIn);
            } else {
                this.field_73032_d.remove((Object)entityIn);
            }
        }
    }

    public void func_73027_a(int entityID, Entity entityToSpawn) {
        Entity entity = this.func_73045_a(entityID);
        if (entity != null) {
            this.func_72900_e(entity);
        }
        this.field_73032_d.add(entityToSpawn);
        entityToSpawn.func_145769_d(entityID);
        if (!this.func_72838_d(entityToSpawn)) {
            this.field_73036_L.add(entityToSpawn);
        }
        this.field_175729_l.func_76038_a(entityID, (Object)entityToSpawn);
    }

    @Override
    @Nullable
    public Entity func_73045_a(int id) {
        return id == this.field_73037_M.field_71439_g.func_145782_y() ? this.field_73037_M.field_71439_g : super.func_73045_a(id);
    }

    public Entity func_73028_b(int entityID) {
        Entity entity = (Entity)((Object)this.field_175729_l.func_76049_d(entityID));
        if (entity != null) {
            this.field_73032_d.remove((Object)entity);
            this.func_72900_e(entity);
        }
        return entity;
    }

    public void func_195597_b(BlockPos pos, IBlockState state) {
        this.func_180501_a(pos, state, 19);
    }

    @Override
    public void func_72882_A() {
        this.field_73035_a.func_147298_b().func_150718_a((ITextComponent)new TextComponentTranslation("multiplayer.status.quitting", new Object[0]));
    }

    @Override
    protected void func_72979_l() {
    }

    @Override
    protected void func_147467_a(int x, int z, Chunk chunkIn) {
        super.func_147467_a(x, z, chunkIn);
        if (this.field_184158_M == 0) {
            this.field_73005_l = this.field_73005_l * 3 + 1013904223;
            int i = this.field_73005_l >> 2;
            int j = i & 0xF;
            int k = i >> 8 & 0xF;
            int l = i >> 16 & 0xFF;
            BlockPos blockpos = new BlockPos(j + x, l, k + z);
            IBlockState iblockstate = chunkIn.func_180495_p(blockpos);
            j += x;
            k += z;
            if (iblockstate.func_196958_f() && this.func_201669_a(blockpos, 0) <= this.field_73012_v.nextInt(8) && this.func_175642_b(EnumLightType.SKY, blockpos) <= 0) {
                double d0 = this.field_73037_M.field_71439_g.func_70092_e((double)j + 0.5, (double)l + 0.5, (double)k + 0.5);
                if (this.field_73037_M.field_71439_g != null && d0 > 4.0 && d0 < 256.0) {
                    this.func_184134_a((double)j + 0.5, (double)l + 0.5, (double)k + 0.5, SoundEvents.field_187674_a, SoundCategory.AMBIENT, 0.7f, 0.8f + this.field_73012_v.nextFloat() * 0.2f, false);
                    this.field_184158_M = this.field_73012_v.nextInt(12000) + 6000;
                }
            }
        }
    }

    public void func_73029_E(int posX, int posY, int posZ) {
        int i = 32;
        Random random = new Random();
        ItemStack itemstack = this.field_73037_M.field_71439_g.func_184614_ca();
        boolean flag = this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE && !itemstack.func_190926_b() && itemstack.func_77973_b() == Blocks.field_180401_cv.func_199767_j();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = 0; j < 667; ++j) {
            this.func_184153_a(posX, posY, posZ, 16, random, flag, blockpos$mutableblockpos);
            this.func_184153_a(posX, posY, posZ, 32, random, flag, blockpos$mutableblockpos);
        }
    }

    public void func_184153_a(int x, int y, int z, int offset, Random random, boolean holdingBarrier, BlockPos.MutableBlockPos pos) {
        int i = x + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        int j = y + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        int k = z + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        pos.func_181079_c(i, j, k);
        IBlockState iblockstate = this.func_180495_p((BlockPos)pos);
        iblockstate.func_177230_c().func_180655_c(iblockstate, this, (BlockPos)pos, random);
        IFluidState ifluidstate = this.func_204610_c((BlockPos)pos);
        if (!ifluidstate.func_206888_e()) {
            ifluidstate.func_206881_a(this, (BlockPos)pos, random);
            IParticleData iparticledata = ifluidstate.func_204521_c();
            if (iparticledata != null && this.field_73012_v.nextInt(10) == 0) {
                boolean flag = iblockstate.func_193401_d((IBlockReader)this, (BlockPos)pos, EnumFacing.DOWN) == BlockFaceShape.SOLID;
                BlockPos blockpos = pos.func_177977_b();
                this.func_211530_a(blockpos, this.func_180495_p(blockpos), iparticledata, flag);
            }
        }
        if (holdingBarrier && iblockstate.func_177230_c() == Blocks.field_180401_cv) {
            this.func_195594_a((IParticleData)Particles.field_197610_c, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, 0.0, 0.0, 0.0);
        }
    }

    private void func_211530_a(BlockPos blockPosIn, IBlockState blockStateIn, IParticleData particleDataIn, boolean shapeDownSolid) {
        if (blockStateIn.func_204520_s().func_206888_e()) {
            VoxelShape voxelshape = blockStateIn.func_196952_d((IBlockReader)this, blockPosIn);
            double d0 = voxelshape.func_197758_c(EnumFacing.Axis.Y);
            if (d0 < 1.0) {
                if (shapeDownSolid) {
                    this.func_211834_a(blockPosIn.func_177958_n(), blockPosIn.func_177958_n() + 1, blockPosIn.func_177952_p(), blockPosIn.func_177952_p() + 1, (double)(blockPosIn.func_177956_o() + 1) - 0.05, particleDataIn);
                }
            } else if (!blockStateIn.func_203425_a(BlockTags.field_211923_H)) {
                double d1 = voxelshape.func_197762_b(EnumFacing.Axis.Y);
                if (d1 > 0.0) {
                    this.func_211835_a(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.func_177956_o() + d1 - 0.05);
                } else {
                    BlockPos blockpos = blockPosIn.func_177977_b();
                    IBlockState iblockstate = this.func_180495_p(blockpos);
                    VoxelShape voxelshape1 = iblockstate.func_196952_d((IBlockReader)this, blockpos);
                    double d2 = voxelshape1.func_197758_c(EnumFacing.Axis.Y);
                    if (d2 < 1.0 && iblockstate.func_204520_s().func_206888_e()) {
                        this.func_211835_a(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.func_177956_o() - 0.05);
                    }
                }
            }
        }
    }

    private void func_211835_a(BlockPos posIn, IParticleData particleDataIn, VoxelShape voxelShapeIn, double p_211835_4_) {
        this.func_211834_a((double)posIn.func_177958_n() + voxelShapeIn.func_197762_b(EnumFacing.Axis.X), (double)posIn.func_177958_n() + voxelShapeIn.func_197758_c(EnumFacing.Axis.X), (double)posIn.func_177952_p() + voxelShapeIn.func_197762_b(EnumFacing.Axis.Z), (double)posIn.func_177952_p() + voxelShapeIn.func_197758_c(EnumFacing.Axis.Z), p_211835_4_, particleDataIn);
    }

    private void func_211834_a(double p_211834_1_, double p_211834_3_, double p_211834_5_, double p_211834_7_, double p_211834_9_, IParticleData p_211834_11_) {
        this.func_195594_a(p_211834_11_, p_211834_1_ + (p_211834_3_ - p_211834_1_) * this.field_73012_v.nextDouble(), p_211834_9_, p_211834_5_ + (p_211834_7_ - p_211834_5_) * this.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
    }

    public void func_73022_a() {
        this.field_72996_f.removeAll(this.field_72997_g);
        for (int i = 0; i < this.field_72997_g.size(); ++i) {
            Entity entity = (Entity)((Object)this.field_72997_g.get(i));
            int j = entity.field_70176_ah;
            int k = entity.field_70164_aj;
            if (!entity.field_70175_ag || !this.func_175680_a(j, k, true)) continue;
            this.func_72964_e(j, k).func_76622_b(entity);
        }
        for (int i1 = 0; i1 < this.field_72997_g.size(); ++i1) {
            this.func_72847_b((Entity)((Object)this.field_72997_g.get(i1)));
        }
        this.field_72997_g.clear();
        for (int j1 = 0; j1 < this.field_72996_f.size(); ++j1) {
            Entity entity1 = (Entity)((Object)this.field_72996_f.get(j1));
            Entity entity2 = entity1.func_184187_bx();
            if (entity2 != null) {
                if (!entity2.field_70128_L && entity2.func_184196_w(entity1)) continue;
                entity1.func_184210_p();
            }
            if (!entity1.field_70128_L) continue;
            int k1 = entity1.field_70176_ah;
            int l = entity1.field_70164_aj;
            if (entity1.field_70175_ag && this.func_175680_a(k1, l, true)) {
                this.func_72964_e(k1, l).func_76622_b(entity1);
            }
            this.field_72996_f.remove(j1--);
            this.func_72847_b(entity1);
        }
    }

    @Override
    public CrashReportCategory func_72914_a(CrashReport report) {
        CrashReportCategory crashreportcategory = super.func_72914_a(report);
        crashreportcategory.func_189529_a("Forced entities", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73032_d.size() + " total; " + this.field_73032_d));
        crashreportcategory.func_189529_a("Retry entities", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73036_L.size() + " total; " + this.field_73036_L));
        crashreportcategory.func_189529_a("Server brand", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73037_M.field_71439_g.func_142021_k()));
        crashreportcategory.func_189529_a("Server type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73037_M.func_71401_C() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server"));
        return crashreportcategory;
    }

    @Override
    public void func_184148_a(@Nullable EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        if (player == this.field_73037_M.field_71439_g) {
            this.func_184134_a(x, y, z, soundIn, category, volume, pitch, false);
        }
    }

    public void func_184156_a(BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundIn, category, volume, pitch, distanceDelay);
    }

    @Override
    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        double d0 = this.field_73037_M.func_175606_aa().func_70092_e(x, y, z);
        SimpleSound simplesound = new SimpleSound(soundIn, category, volume, pitch, (float)x, (float)y, (float)z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.field_73037_M.func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)simplesound);
        }
    }

    @Override
    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable NBTTagCompound compound) {
        this.field_73037_M.field_71452_i.func_78873_a((Particle)new ParticleFirework.Starter((World)this, x, y, z, motionX, motionY, motionZ, this.field_73037_M.field_71452_i, compound));
    }

    @Override
    public void func_184135_a(Packet<?> packetIn) {
        this.field_73035_a.func_147297_a(packetIn);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73035_a.func_199526_e();
    }

    public void func_96443_a(Scoreboard scoreboardIn) {
        this.field_200261_M = scoreboardIn;
    }

    @Override
    public void func_72877_b(long time) {
        if (time < 0L) {
            time = -time;
            this.func_82736_K().func_82764_b("doDaylightCycle", "false", (MinecraftServer)null);
        } else {
            this.func_82736_K().func_82764_b("doDaylightCycle", "true", (MinecraftServer)null);
        }
        super.func_72877_b(time);
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    @Override
    public ChunkProviderClient func_72863_F() {
        return (ChunkProviderClient)super.func_72863_F();
    }

    @Override
    public Scoreboard func_96441_U() {
        return this.field_200261_M;
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73035_a.func_199724_l();
    }
}

