/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderLivingBase<T extends EntityLivingBase>
extends Render<T> {
    private static final Logger field_147923_a = LogManager.getLogger();
    private static final DynamicTexture field_177096_e = (DynamicTexture)Util.func_200696_a((Object)new DynamicTexture(16, 16, false), p_203414_0_ -> {
        p_203414_0_.func_195414_e().func_195711_f();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                p_203414_0_.func_195414_e().func_195700_a(j, i, -1);
            }
        }
        p_203414_0_.func_110564_a();
    });
    protected ModelBase field_77045_g;
    protected FloatBuffer field_177095_g = GLAllocation.func_74529_h((int)4);
    protected List<LayerRenderer<T>> field_177097_h = Lists.newArrayList();
    protected boolean field_188323_j;

    public RenderLivingBase(RenderManager renderManagerIn, ModelBase modelBaseIn, float shadowSizeIn) {
        super(renderManagerIn);
        this.field_77045_g = modelBaseIn;
        this.field_76989_e = shadowSizeIn;
    }

    public <V extends EntityLivingBase, U extends LayerRenderer<V>> boolean func_177094_a(U layer) {
        return this.field_177097_h.add(layer);
    }

    public ModelBase func_177087_b() {
        return this.field_77045_g;
    }

    protected float func_77034_a(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entity, this, partialTicks, x, y, z))) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        this.field_77045_g.field_78095_p = this.func_77040_d(entity, partialTicks);
        this.field_77045_g.field_78093_q = shouldSit = ((Entity)((Object)entity)).func_184218_aH() && ((Entity)((Object)entity)).func_184187_bx() != null && ((Entity)((Object)entity)).func_184187_bx().shouldRiderSit();
        this.field_77045_g.field_78091_s = ((EntityLivingBase)((Object)entity)).func_70631_g_();
        try {
            float f = this.func_77034_a(((EntityLivingBase)((Object)entity)).field_70760_ar, ((EntityLivingBase)((Object)entity)).field_70761_aq, partialTicks);
            float f1 = this.func_77034_a(((EntityLivingBase)((Object)entity)).field_70758_at, ((EntityLivingBase)((Object)entity)).field_70759_as, partialTicks);
            float f2 = f1 - f;
            if (shouldSit && ((Entity)((Object)entity)).func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)((Entity)((Object)entity)).func_184187_bx();
                f = this.func_77034_a(entitylivingbase.field_70760_ar, entitylivingbase.field_70761_aq, partialTicks);
                f2 = f1 - f;
                float f3 = MathHelper.func_76142_g((float)f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                }
                f = f1 - f3;
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
                f2 = f1 - f;
            }
            float f7 = ((EntityLivingBase)((Object)entity)).field_70127_C + (((EntityLivingBase)((Object)entity)).field_70125_A - ((EntityLivingBase)((Object)entity)).field_70127_C) * partialTicks;
            this.func_77039_a(entity, x, y, z);
            float f8 = this.func_77044_a(entity, partialTicks);
            this.func_77043_a(entity, f8, f, partialTicks);
            float f4 = this.func_188322_c(entity, partialTicks);
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (!((Entity)((Object)entity)).func_184218_aH()) {
                f5 = ((EntityLivingBase)((Object)entity)).field_184618_aE + (((EntityLivingBase)((Object)entity)).field_70721_aZ - ((EntityLivingBase)((Object)entity)).field_184618_aE) * partialTicks;
                f6 = ((EntityLivingBase)((Object)entity)).field_184619_aG - ((EntityLivingBase)((Object)entity)).field_70721_aZ * (1.0f - partialTicks);
                if (((EntityLivingBase)((Object)entity)).func_70631_g_()) {
                    f6 *= 3.0f;
                }
                if (f5 > 1.0f) {
                    f5 = 1.0f;
                }
            }
            GlStateManager.func_179141_d();
            this.field_77045_g.func_78086_a(entity, f6, f5, partialTicks);
            this.field_77045_g.func_78087_a(f6, f5, f8, f2, f7, f4, entity);
            if (this.field_188301_f) {
                boolean flag1 = this.func_177088_c(entity);
                GlStateManager.func_179142_g();
                GlStateManager.func_187431_e((int)this.func_188298_c((Entity)((Object)entity)));
                if (!this.field_188323_j) {
                    this.func_77036_a(entity, f6, f5, f8, f2, f7, f4);
                }
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)((Object)entity)).func_175149_v()) {
                    this.func_177093_a(entity, f6, f5, partialTicks, f8, f2, f7, f4);
                }
                GlStateManager.func_187417_n();
                GlStateManager.func_179119_h();
                if (flag1) {
                    this.func_180565_e();
                }
            } else {
                boolean flag = this.func_177090_c(entity, partialTicks);
                this.func_77036_a(entity, f6, f5, f8, f2, f7, f4);
                if (flag) {
                    this.func_177091_f();
                }
                GlStateManager.func_179132_a((boolean)true);
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)((Object)entity)).func_175149_v()) {
                    this.func_177093_a(entity, f6, f5, partialTicks, f8, f2, f7, f4);
                }
            }
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            field_147923_a.error("Couldn't render entity", (Throwable)exception);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entity, this, partialTicks, x, y, z));
    }

    public float func_188322_c(T entitylivingbaseIn, float partialTicks) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.func_77041_b(entitylivingbaseIn, partialTicks);
        float f = 0.0625f;
        GlStateManager.func_179109_b((float)0.0f, (float)-1.501f, (float)0.0f);
        return 0.0625f;
    }

    protected boolean func_177088_c(T entityLivingBaseIn) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }

    protected void func_180565_e() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void func_77036_a(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = this.func_193115_c(entitylivingbaseIn);
        boolean bl = flag1 = !flag && !((Entity)((Object)entitylivingbaseIn)).func_98034_c(Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)((Object)entitylivingbaseIn))) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            this.field_77045_g.func_78088_a(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (flag1) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    protected boolean func_193115_c(T p_193115_1_) {
        return !((Entity)((Object)p_193115_1_)).func_82150_aj() || this.field_188301_f;
    }

    protected boolean func_177090_c(T entityLivingBaseIn, float partialTicks) {
        return this.func_177092_a(entityLivingBaseIn, partialTicks, true);
    }

    protected boolean func_177092_a(T entitylivingbaseIn, float partialTicks, boolean combineTextures) {
        boolean flag1;
        float f = ((Entity)((Object)entitylivingbaseIn)).func_70013_c();
        int i = this.func_77030_a(entitylivingbaseIn, f, partialTicks);
        boolean flag = (i >> 24 & 0xFF) > 0;
        boolean bl = flag1 = ((EntityLivingBase)((Object)entitylivingbaseIn)).field_70737_aN > 0 || ((EntityLivingBase)((Object)entitylivingbaseIn)).field_70725_aQ > 0;
        if (!flag && !flag1) {
            return false;
        }
        if (!flag && !combineTextures) {
            return false;
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)OpenGlHelper.field_176094_t);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176080_A, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176076_D, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        this.field_177095_g.position(0);
        if (flag1) {
            this.field_177095_g.put(1.0f);
            this.field_177095_g.put(0.0f);
            this.field_177095_g.put(0.0f);
            this.field_177095_g.put(0.3f);
        } else {
            float f1 = (float)(i >> 24 & 0xFF) / 255.0f;
            float f2 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f4 = (float)(i & 0xFF) / 255.0f;
            this.field_177095_g.put(f2);
            this.field_177095_g.put(f3);
            this.field_177095_g.put(f4);
            this.field_177095_g.put(1.0f - f1);
        }
        this.field_177095_g.flip();
        GlStateManager.func_187448_b((int)8960, (int)8705, (FloatBuffer)this.field_177095_g);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)field_177096_e.func_110552_b());
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }

    protected void func_177091_f() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176079_G, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176086_J, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179090_x();
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void func_77039_a(T entityLivingBaseIn, double x, double y, double z) {
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
    }

    protected void func_77043_a(T entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (((EntityLivingBase)((Object)entityLiving)).field_70725_aQ > 0) {
            float f = ((float)((EntityLivingBase)((Object)entityLiving)).field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.func_77037_a(entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (((EntityLivingBase)((Object)entityLiving)).func_204805_cN()) {
            GlStateManager.func_179114_b((float)(-90.0f - ((EntityLivingBase)((Object)entityLiving)).field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(((float)((EntityLivingBase)((Object)entityLiving)).field_70173_aa + partialTicks) * -75.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else if ((((Entity)((Object)entityLiving)).func_145818_k_() || entityLiving instanceof EntityPlayer) && (s = TextFormatting.func_110646_a((String)((Entity)((Object)entityLiving)).func_200200_C_().getString())) != null && ("Dinnerbone".equals(s) || "Grumm".equals(s)) && (!(entityLiving instanceof EntityPlayer) || ((EntityPlayer)((Object)entityLiving)).func_175148_a(EnumPlayerModelParts.CAPE))) {
            GlStateManager.func_179109_b((float)0.0f, (float)(((EntityLivingBase)((Object)entityLiving)).field_70131_O + 0.1f), (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float func_77040_d(T livingBase, float partialTickTime) {
        return ((EntityLivingBase)((Object)livingBase)).func_70678_g(partialTickTime);
    }

    protected float func_77044_a(T livingBase, float partialTicks) {
        return (float)((EntityLivingBase)((Object)livingBase)).field_70173_aa + partialTicks;
    }

    protected void func_177093_a(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        for (LayerRenderer<T> layerrenderer : this.field_177097_h) {
            boolean flag = this.func_177092_a(entitylivingbaseIn, partialTicks, layerrenderer.func_177142_b());
            layerrenderer.func_177141_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn);
            if (!flag) continue;
            this.func_177091_f();
        }
    }

    protected float func_77037_a(T entityLivingBaseIn) {
        return 90.0f;
    }

    protected int func_77030_a(T entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        return 0;
    }

    protected void func_77041_b(T entitylivingbaseIn, float partialTickTime) {
    }

    public void func_177067_a(T entity, double x, double y, double z) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Specials.Pre(entity, this, x, y, z))) {
            return;
        }
        if (this.func_177070_b(entity)) {
            double d0 = ((Entity)((Object)entity)).func_70068_e(this.field_76990_c.field_78734_h);
            float f = (float)((EntityLivingBase)((Object)entity)).func_110148_a(EntityLivingBase.NAMETAG_DISTANCE).func_111126_e();
            if (((Entity)((Object)entity)).func_70093_af()) {
                f /= 2.0f;
            }
            if (!(d0 >= (double)(f * f))) {
                String s = ((Entity)((Object)entity)).func_145748_c_().func_150254_d();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                this.func_188296_a((Entity)((Object)entity), x, y, z, s, d0);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Specials.Post(entity, this, x, y, z));
    }

    protected boolean func_177070_b(T entity) {
        boolean flag;
        EntityPlayerSP entityplayersp = Minecraft.func_71410_x().field_71439_g;
        boolean bl = flag = !((Entity)((Object)entity)).func_98034_c(entityplayersp);
        if (entity != entityplayersp) {
            Team team = ((Entity)((Object)entity)).func_96124_cp();
            Team team1 = entityplayersp.func_96124_cp();
            if (team != null) {
                Team.EnumVisible team$enumvisible = team.func_178770_i();
                switch (team$enumvisible) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.func_142054_a(team1) && (team.func_98297_h() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.func_142054_a(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && entity != this.field_76990_c.field_78734_h && flag && !((Entity)((Object)entity)).func_184207_aI();
    }
}

