/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArmorDyeable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public abstract class LayerArmorBase<T extends ModelBase>
implements LayerRenderer<EntityLivingBase> {
    protected static final ResourceLocation field_177188_b = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected T field_177189_c;
    protected T field_177186_d;
    private final RenderLivingBase<?> field_177190_a;
    private float field_177187_e = 1.0f;
    private float field_177184_f = 1.0f;
    private float field_177185_g = 1.0f;
    private float field_177192_h = 1.0f;
    private boolean field_177193_i;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();

    public LayerArmorBase(RenderLivingBase<?> rendererIn) {
        this.field_177190_a = rendererIn;
        this.func_177177_a();
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_188361_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.func_188361_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.func_188361_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.func_188361_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    public boolean func_177142_b() {
        return false;
    }

    private void func_188361_a(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ItemArmor itemarmor;
        ItemStack itemstack = entityLivingBaseIn.func_184582_a(slotIn);
        if (itemstack.func_77973_b() instanceof ItemArmor && (itemarmor = (ItemArmor)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            T t = this.func_188360_a(slotIn);
            t = this.getArmorModelHook(entityLivingBaseIn, itemstack, slotIn, t);
            t.func_178686_a(this.field_177190_a.func_177087_b());
            t.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.func_188359_a(t, slotIn);
            boolean flag = this.func_188363_b(slotIn);
            this.field_177190_a.func_110776_a(this.getArmorResource(entityLivingBaseIn, itemstack, slotIn, null));
            if (itemarmor instanceof ItemArmorDyeable) {
                int i = ((ItemArmorDyeable)itemarmor).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(this.field_177184_f * f), (float)(this.field_177185_g * f1), (float)(this.field_177192_h * f2), (float)this.field_177187_e);
                t.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.field_177190_a.func_110776_a(this.func_177178_a(itemarmor, flag, "overlay"));
            }
            GlStateManager.func_179131_c((float)this.field_177184_f, (float)this.field_177185_g, (float)this.field_177192_h, (float)this.field_177187_e);
            t.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            if (!this.field_177193_i && itemstack.func_77962_s()) {
                LayerArmorBase.func_188364_a(this.field_177190_a, entityLivingBaseIn, t, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
    }

    public T func_188360_a(EntityEquipmentSlot slotIn) {
        return this.func_188363_b(slotIn) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }

    public static void func_188364_a(RenderLivingBase<?> p_188364_0_, EntityLivingBase p_188364_1_, ModelBase model, float p_188364_3_, float p_188364_4_, float p_188364_5_, float p_188364_6_, float p_188364_7_, float p_188364_8_, float p_188364_9_) {
        float f = (float)p_188364_1_.field_70173_aa + p_188364_5_;
        p_188364_0_.func_110776_a(field_177188_b);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179132_a((boolean)false);
        float f1 = 0.5f;
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float f2 = 0.76f;
            GlStateManager.func_179131_c((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f3 = 0.33333334f;
            GlStateManager.func_179152_a((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            model.func_78088_a((Entity)p_188364_1_, p_188364_3_, p_188364_4_, p_188364_6_, p_188364_7_, p_188364_8_, p_188364_9_);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
    }

    @Deprecated
    private ResourceLocation func_177181_a(ItemArmor armor, boolean p_177181_2_) {
        return this.func_177178_a(armor, p_177181_2_, null);
    }

    @Deprecated
    private ResourceLocation func_177178_a(ItemArmor armor, boolean p_177178_2_, @Nullable String p_177178_3_) {
        String s = "textures/models/armor/" + armor.func_200880_d().func_200897_d() + "_layer_" + (p_177178_2_ ? 2 : 1) + (p_177178_3_ == null ? "" : "_" + p_177178_3_) + ".png";
        return field_177191_j.computeIfAbsent(s, ResourceLocation::new);
    }

    protected abstract void func_177177_a();

    protected abstract void func_188359_a(T var1, EntityEquipmentSlot var2);

    protected T getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, T model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, @Nullable String type) {
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.func_188363_b(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

