/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.model.ITransformation;

@OnlyIn(value=Dist.CLIENT)
public class FaceBakery {
    private static final float field_178418_a = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float field_178417_b = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    private static final Rotation[] field_188016_c = new Rotation[ModelRotation.values().length * EnumFacing.values().length];
    private static final Rotation field_188017_d = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float u1, float v1, float u2, float v2) {
            return new BlockFaceUV(new float[]{u1, v1, u2, v2}, 0);
        }
    };
    private static final Rotation field_188018_e = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float u1, float v1, float u2, float v2) {
            return new BlockFaceUV(new float[]{v2, 16.0f - u1, v1, 16.0f - u2}, 270);
        }
    };
    private static final Rotation field_188019_f = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float u1, float v1, float u2, float v2) {
            return new BlockFaceUV(new float[]{16.0f - u1, 16.0f - v1, 16.0f - u2, 16.0f - v2}, 0);
        }
    };
    private static final Rotation field_188020_g = new Rotation(){

        @Override
        BlockFaceUV func_188007_a(float u1, float v1, float u2, float v2) {
            return new BlockFaceUV(new float[]{16.0f - v1, u2, 16.0f - v2, u1}, 90);
        }
    };

    public BakedQuad func_199332_a(Vector3f posFrom, Vector3f posTo, BlockPartFace face, TextureAtlasSprite sprite, EnumFacing facing, ModelRotation modelRotationIn, @Nullable BlockPartRotation partRotation, boolean uvLocked, boolean shade) {
        return this.makeBakedQuad(posFrom, posTo, face, sprite, facing, modelRotationIn, partRotation, uvLocked, shade);
    }

    public BakedQuad makeBakedQuad(Vector3f posFrom, Vector3f posTo, BlockPartFace face, TextureAtlasSprite sprite, EnumFacing facing, ITransformation modelRotationIn, BlockPartRotation partRotation, boolean uvLocked, boolean shade) {
        BlockFaceUV blockfaceuv = face.field_178243_e;
        if (uvLocked) {
            blockfaceuv = ForgeHooksClient.applyUVLock((BlockFaceUV)face.field_178243_e, (EnumFacing)facing, (ITransformation)modelRotationIn);
        }
        int[] aint = this.makeQuadVertexData(blockfaceuv, sprite, facing, this.func_199337_a(posFrom, posTo), modelRotationIn, partRotation, false);
        EnumFacing enumfacing = FaceBakery.func_178410_a(aint);
        if (partRotation == null) {
            this.func_178408_a(aint, enumfacing);
        }
        ForgeHooksClient.fillNormal((int[])aint, (EnumFacing)enumfacing);
        return new BakedQuad(aint, face.field_178245_c, enumfacing, sprite, shade, DefaultVertexFormats.field_176599_b);
    }

    private BlockFaceUV func_188010_a(BlockFaceUV blockFaceUVIn, EnumFacing facing, ModelRotation modelRotationIn) {
        return field_188016_c[FaceBakery.func_188014_a(modelRotationIn, facing)].func_188006_a(blockFaceUVIn);
    }

    private int[] func_188012_a(BlockFaceUV uvs, TextureAtlasSprite sprite, EnumFacing orientation, float[] posDiv16, ModelRotation rotationIn, @Nullable BlockPartRotation partRotation, boolean shade) {
        return this.makeQuadVertexData(uvs, sprite, orientation, posDiv16, rotationIn, partRotation, shade);
    }

    private int[] makeQuadVertexData(BlockFaceUV uvs, TextureAtlasSprite sprite, EnumFacing orientation, float[] posDiv16, ITransformation rotationIn, BlockPartRotation partRotation, boolean shade) {
        int[] aint = new int[28];
        for (int i = 0; i < 4; ++i) {
            this.fillVertexData(aint, i, orientation, uvs, posDiv16, sprite, rotationIn, partRotation, shade);
        }
        return aint;
    }

    private int func_178413_a(EnumFacing facing) {
        float f = this.func_178412_b(facing);
        int i = MathHelper.func_76125_a((int)((int)(f * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | i << 8 | i;
    }

    private float func_178412_b(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    private float[] func_199337_a(Vector3f pos1, Vector3f pos2) {
        float[] afloat = new float[EnumFacing.values().length];
        afloat[EnumFaceDirection.Constants.field_179176_f] = pos1.func_195899_a() / 16.0f;
        afloat[EnumFaceDirection.Constants.field_179178_e] = pos1.func_195900_b() / 16.0f;
        afloat[EnumFaceDirection.Constants.field_179177_d] = pos1.func_195902_c() / 16.0f;
        afloat[EnumFaceDirection.Constants.field_179180_c] = pos2.func_195899_a() / 16.0f;
        afloat[EnumFaceDirection.Constants.field_179179_b] = pos2.func_195900_b() / 16.0f;
        afloat[EnumFaceDirection.Constants.field_179181_a] = pos2.func_195902_c() / 16.0f;
        return afloat;
    }

    private void func_188015_a(int[] vertexData, int vertexIndex, EnumFacing facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, ModelRotation rotationIn, @Nullable BlockPartRotation partRotation, boolean shade) {
        this.fillVertexData(vertexData, vertexIndex, facing, blockFaceUVIn, posDiv16, sprite, rotationIn, partRotation, shade);
    }

    private void fillVertexData(int[] vertexData, int vertexIndex, EnumFacing facing, BlockFaceUV blockFaceUVIn, float[] posDiv16, TextureAtlasSprite sprite, ITransformation rotationIn, BlockPartRotation partRotation, boolean shade) {
        EnumFacing enumfacing = rotationIn.rotate(facing);
        int i = shade ? this.func_178413_a(enumfacing) : -1;
        EnumFaceDirection.VertexInformation enumfacedirection$vertexinformation = EnumFaceDirection.func_179027_a((EnumFacing)facing).func_179025_a(vertexIndex);
        Vector3f vector3f = new Vector3f(posDiv16[enumfacedirection$vertexinformation.field_179184_a], posDiv16[enumfacedirection$vertexinformation.field_179182_b], posDiv16[enumfacedirection$vertexinformation.field_179183_c]);
        this.func_199336_a(vector3f, partRotation);
        int j = this.rotateVertex(vector3f, facing, vertexIndex, rotationIn);
        this.func_199333_a(vertexData, j, vertexIndex, vector3f, i, sprite, blockFaceUVIn);
    }

    private void func_199333_a(int[] faceData, int storeIndex, int vertexIndex, Vector3f position, int shadeColor, TextureAtlasSprite sprite, BlockFaceUV faceUV) {
        int i = storeIndex * 7;
        faceData[i] = Float.floatToRawIntBits(position.func_195899_a());
        faceData[i + 1] = Float.floatToRawIntBits(position.func_195900_b());
        faceData[i + 2] = Float.floatToRawIntBits(position.func_195902_c());
        faceData[i + 3] = shadeColor;
        faceData[i + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)faceUV.func_178348_a(vertexIndex) * 0.999 + (double)faceUV.func_178348_a((vertexIndex + 2) % 4) * 0.001));
        faceData[i + 4 + 1] = Float.floatToRawIntBits(sprite.func_94207_b((double)faceUV.func_178346_b(vertexIndex) * 0.999 + (double)faceUV.func_178346_b((vertexIndex + 2) % 4) * 0.001));
    }

    private void func_199336_a(Vector3f vec, @Nullable BlockPartRotation partRotation) {
        if (partRotation != null) {
            Vector3f vector3f1;
            Vector3f vector3f;
            switch (partRotation.field_178342_b) {
                case X: {
                    vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
                    vector3f1 = new Vector3f(0.0f, 1.0f, 1.0f);
                    break;
                }
                case Y: {
                    vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
                    vector3f1 = new Vector3f(1.0f, 0.0f, 1.0f);
                    break;
                }
                case Z: {
                    vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
                    vector3f1 = new Vector3f(1.0f, 1.0f, 0.0f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("There are only 3 axes");
                }
            }
            Quaternion quaternion = new Quaternion(vector3f, partRotation.field_178343_c, true);
            if (partRotation.field_178341_d) {
                if (Math.abs(partRotation.field_178343_c) == 22.5f) {
                    vector3f1.func_195898_a(field_178418_a);
                } else {
                    vector3f1.func_195898_a(field_178417_b);
                }
                vector3f1.func_195904_b(1.0f, 1.0f, 1.0f);
            } else {
                vector3f1.func_195905_a(1.0f, 1.0f, 1.0f);
            }
            this.func_199334_a(vec, new Vector3f(partRotation.field_178344_a), quaternion, vector3f1);
        }
    }

    public int func_199335_a(Vector3f p_199335_1_, EnumFacing p_199335_2_, int p_199335_3_, ModelRotation p_199335_4_) {
        return this.rotateVertex(p_199335_1_, p_199335_2_, p_199335_3_, p_199335_4_);
    }

    public int rotateVertex(Vector3f p_199335_1_, EnumFacing p_199335_2_, int p_199335_3_, ITransformation p_199335_4_) {
        if (p_199335_4_ == ModelRotation.X0_Y0) {
            return p_199335_3_;
        }
        ForgeHooksClient.transform((Vector3f)p_199335_1_, (Matrix4f)p_199335_4_.getMatrixVec());
        return p_199335_4_.rotate(p_199335_2_, p_199335_3_);
    }

    private void func_199334_a(Vector3f p_199334_1_, Vector3f p_199334_2_, Quaternion p_199334_3_, Vector3f p_199334_4_) {
        Vector4f vector4f = new Vector4f(p_199334_1_.func_195899_a() - p_199334_2_.func_195899_a(), p_199334_1_.func_195900_b() - p_199334_2_.func_195900_b(), p_199334_1_.func_195902_c() - p_199334_2_.func_195902_c(), 1.0f);
        vector4f.func_195912_a(p_199334_3_);
        vector4f.func_195909_a(p_199334_4_);
        p_199334_1_.func_195905_a(vector4f.func_195910_a() + p_199334_2_.func_195899_a(), vector4f.func_195913_b() + p_199334_2_.func_195900_b(), vector4f.func_195914_c() + p_199334_2_.func_195902_c());
    }

    public static EnumFacing func_178410_a(int[] faceData) {
        Vector3f vector3f = new Vector3f(Float.intBitsToFloat(faceData[0]), Float.intBitsToFloat(faceData[1]), Float.intBitsToFloat(faceData[2]));
        Vector3f vector3f1 = new Vector3f(Float.intBitsToFloat(faceData[7]), Float.intBitsToFloat(faceData[8]), Float.intBitsToFloat(faceData[9]));
        Vector3f vector3f2 = new Vector3f(Float.intBitsToFloat(faceData[14]), Float.intBitsToFloat(faceData[15]), Float.intBitsToFloat(faceData[16]));
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f3.func_195897_a(vector3f1);
        Vector3f vector3f4 = new Vector3f(vector3f2);
        vector3f4.func_195897_a(vector3f1);
        Vector3f vector3f5 = new Vector3f(vector3f4);
        vector3f5.func_195896_c(vector3f3);
        vector3f5.func_195906_d();
        EnumFacing enumfacing = null;
        float f = 0.0f;
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            Vec3i vec3i = enumfacing1.func_176730_m();
            Vector3f vector3f6 = new Vector3f((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            float f1 = vector3f5.func_195903_b(vector3f6);
            if (!(f1 >= 0.0f) || !(f1 > f)) continue;
            f = f1;
            enumfacing = enumfacing1;
        }
        if (enumfacing == null) {
            return EnumFacing.UP;
        }
        return enumfacing;
    }

    private void func_178408_a(int[] p_178408_1_, EnumFacing p_178408_2_) {
        int[] aint = new int[p_178408_1_.length];
        System.arraycopy(p_178408_1_, 0, aint, 0, p_178408_1_.length);
        float[] afloat = new float[EnumFacing.values().length];
        afloat[EnumFaceDirection.Constants.field_179176_f] = 999.0f;
        afloat[EnumFaceDirection.Constants.field_179178_e] = 999.0f;
        afloat[EnumFaceDirection.Constants.field_179177_d] = 999.0f;
        afloat[EnumFaceDirection.Constants.field_179180_c] = -999.0f;
        afloat[EnumFaceDirection.Constants.field_179179_b] = -999.0f;
        afloat[EnumFaceDirection.Constants.field_179181_a] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 7 * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[EnumFaceDirection.Constants.field_179176_f]) {
                afloat[EnumFaceDirection.Constants.field_179176_f] = f;
            }
            if (f1 < afloat[EnumFaceDirection.Constants.field_179178_e]) {
                afloat[EnumFaceDirection.Constants.field_179178_e] = f1;
            }
            if (f2 < afloat[EnumFaceDirection.Constants.field_179177_d]) {
                afloat[EnumFaceDirection.Constants.field_179177_d] = f2;
            }
            if (f > afloat[EnumFaceDirection.Constants.field_179180_c]) {
                afloat[EnumFaceDirection.Constants.field_179180_c] = f;
            }
            if (f1 > afloat[EnumFaceDirection.Constants.field_179179_b]) {
                afloat[EnumFaceDirection.Constants.field_179179_b] = f1;
            }
            if (!(f2 > afloat[EnumFaceDirection.Constants.field_179181_a])) continue;
            afloat[EnumFaceDirection.Constants.field_179181_a] = f2;
        }
        EnumFaceDirection enumfacedirection = EnumFaceDirection.func_179027_a((EnumFacing)p_178408_2_);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 7 * i1;
            EnumFaceDirection.VertexInformation enumfacedirection$vertexinformation = enumfacedirection.func_179025_a(i1);
            float f8 = afloat[enumfacedirection$vertexinformation.field_179184_a];
            float f3 = afloat[enumfacedirection$vertexinformation.field_179182_b];
            float f4 = afloat[enumfacedirection$vertexinformation.field_179183_c];
            p_178408_1_[j1] = Float.floatToRawIntBits(f8);
            p_178408_1_[j1 + 1] = Float.floatToRawIntBits(f3);
            p_178408_1_[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 7 * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!MathHelper.func_180185_a((float)f8, (float)f5) || !MathHelper.func_180185_a((float)f3, (float)f6) || !MathHelper.func_180185_a((float)f4, (float)f7)) continue;
                p_178408_1_[j1 + 4] = aint[l + 4];
                p_178408_1_[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }

    private static void func_188013_a(ModelRotation p_188013_0_, EnumFacing p_188013_1_, Rotation p_188013_2_) {
        FaceBakery.field_188016_c[FaceBakery.func_188014_a((ModelRotation)p_188013_0_, (EnumFacing)p_188013_1_)] = p_188013_2_;
    }

    private static int func_188014_a(ModelRotation p_188014_0_, EnumFacing p_188014_1_) {
        return ModelRotation.values().length * p_188014_1_.ordinal() + p_188014_0_.ordinal();
    }

    static {
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, EnumFacing.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, EnumFacing.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, EnumFacing.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, EnumFacing.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, EnumFacing.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y0, EnumFacing.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, EnumFacing.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, EnumFacing.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, EnumFacing.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, EnumFacing.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, EnumFacing.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, EnumFacing.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, EnumFacing.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, EnumFacing.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, EnumFacing.EAST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, EnumFacing.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, EnumFacing.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, EnumFacing.WEST, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, EnumFacing.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, EnumFacing.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, EnumFacing.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, EnumFacing.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, EnumFacing.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, EnumFacing.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, EnumFacing.DOWN, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, EnumFacing.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, EnumFacing.SOUTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, EnumFacing.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, EnumFacing.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, EnumFacing.NORTH, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, EnumFacing.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, EnumFacing.UP, field_188017_d);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, EnumFacing.UP, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, EnumFacing.DOWN, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, EnumFacing.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, EnumFacing.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, EnumFacing.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, EnumFacing.NORTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, EnumFacing.SOUTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, EnumFacing.WEST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, EnumFacing.UP, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, EnumFacing.DOWN, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, EnumFacing.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, EnumFacing.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, EnumFacing.NORTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, EnumFacing.SOUTH, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, EnumFacing.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, EnumFacing.EAST, field_188018_e);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, EnumFacing.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X0_Y180, EnumFacing.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, EnumFacing.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, EnumFacing.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, EnumFacing.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, EnumFacing.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, EnumFacing.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, EnumFacing.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, EnumFacing.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, EnumFacing.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, EnumFacing.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y0, EnumFacing.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, EnumFacing.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, EnumFacing.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, EnumFacing.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, EnumFacing.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, EnumFacing.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, EnumFacing.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, EnumFacing.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, EnumFacing.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, EnumFacing.UP, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y180, EnumFacing.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, EnumFacing.EAST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, EnumFacing.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, EnumFacing.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, EnumFacing.WEST, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, EnumFacing.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, EnumFacing.NORTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, EnumFacing.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, EnumFacing.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, EnumFacing.SOUTH, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, EnumFacing.DOWN, field_188019_f);
        FaceBakery.func_188013_a(ModelRotation.X0_Y90, EnumFacing.UP, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X0_Y270, EnumFacing.DOWN, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y0, EnumFacing.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, EnumFacing.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, EnumFacing.NORTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y90, EnumFacing.SOUTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y180, EnumFacing.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X90_Y270, EnumFacing.EAST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y0, EnumFacing.WEST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X180_Y90, EnumFacing.DOWN, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X180_Y270, EnumFacing.UP, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y90, EnumFacing.WEST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y180, EnumFacing.WEST, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, EnumFacing.NORTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, EnumFacing.SOUTH, field_188020_g);
        FaceBakery.func_188013_a(ModelRotation.X270_Y270, EnumFacing.WEST, field_188020_g);
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class Rotation {
        private Rotation() {
        }

        public BlockFaceUV func_188006_a(BlockFaceUV blockFaceUVIn) {
            float f = blockFaceUVIn.func_178348_a(blockFaceUVIn.func_178345_c(0));
            float f1 = blockFaceUVIn.func_178346_b(blockFaceUVIn.func_178345_c(0));
            float f2 = blockFaceUVIn.func_178348_a(blockFaceUVIn.func_178345_c(2));
            float f3 = blockFaceUVIn.func_178346_b(blockFaceUVIn.func_178345_c(2));
            return this.func_188007_a(f, f1, f2, f3);
        }

        abstract BlockFaceUV func_188007_a(float var1, float var2, float var3, float var4);
    }
}

