/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemOverrideList {
    public static final ItemOverrideList field_188022_a = new ItemOverrideList();
    private final List<ItemOverride> field_188023_b = Lists.newArrayList();
    private final List<IBakedModel> field_209582_c;

    protected ItemOverrideList() {
        this.field_209582_c = Collections.emptyList();
    }

    public ItemOverrideList(IUnbakedModel model, Function<ResourceLocation, IUnbakedModel> modelGetter, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, List<ItemOverride> overridesIn) {
        this.field_209582_c = overridesIn.stream().map(p_209580_3_ -> {
            IUnbakedModel iunbakedmodel = (IUnbakedModel)modelGetter.apply(p_209580_3_.func_188026_a());
            return Objects.equals(iunbakedmodel, model) ? null : iunbakedmodel.func_209558_a(modelGetter, spriteGetter, ModelRotation.X0_Y0, false);
        }).collect(Collectors.toList());
        Collections.reverse(this.field_209582_c);
        for (int i = overridesIn.size() - 1; i >= 0; --i) {
            this.field_188023_b.add(overridesIn.get(i));
        }
    }

    @Nullable
    public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
        if (!this.field_188023_b.isEmpty()) {
            for (int i = 0; i < this.field_188023_b.size(); ++i) {
                ItemOverride itemoverride = this.field_188023_b.get(i);
                if (!itemoverride.func_188027_a(stack, worldIn, entityIn)) continue;
                IBakedModel ibakedmodel = this.field_209582_c.get(i);
                if (ibakedmodel == null) {
                    return model;
                }
                return ibakedmodel;
            }
        }
        return model;
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return ImmutableList.copyOf(this.field_188023_b);
    }
}

