/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBlock
implements IUnbakedModel {
    private static final Logger field_178313_f = LogManager.getLogger();
    private static final ItemModelGenerator field_209571_g = new ItemModelGenerator();
    private static final FaceBakery field_209572_h = new FaceBakery();
    @VisibleForTesting
    static final Gson field_178319_a = new GsonBuilder().registerTypeAdapter(ModelBlock.class, (Object)new Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private final List<BlockPart> field_178314_g;
    private final boolean field_178321_h;
    public final boolean field_178322_i;
    private final ItemCameraTransforms field_178320_j;
    private final List<ItemOverride> field_187968_k;
    public String field_178317_b = "";
    @VisibleForTesting
    public final Map<String, String> field_178318_c;
    @VisibleForTesting
    public ModelBlock field_178315_d;
    @VisibleForTesting
    ResourceLocation field_178316_e;

    public static ModelBlock func_178307_a(Reader readerIn) {
        return (ModelBlock)JsonUtils.func_193839_a((Gson)field_178319_a, (Reader)readerIn, ModelBlock.class);
    }

    public static ModelBlock func_178294_a(String jsonString) {
        return ModelBlock.func_178307_a(new StringReader(jsonString));
    }

    public ModelBlock(@Nullable ResourceLocation parentLocationIn, List<BlockPart> elementsIn, Map<String, String> texturesIn, boolean ambientOcclusionIn, boolean gui3dIn, ItemCameraTransforms cameraTransformsIn, List<ItemOverride> overridesIn) {
        this.field_178314_g = elementsIn;
        this.field_178322_i = ambientOcclusionIn;
        this.field_178321_h = gui3dIn;
        this.field_178318_c = texturesIn;
        this.field_178316_e = parentLocationIn;
        this.field_178320_j = cameraTransformsIn;
        this.field_187968_k = overridesIn;
    }

    public List<BlockPart> func_178298_a() {
        return this.field_178314_g.isEmpty() && this.func_178295_k() ? this.field_178315_d.func_178298_a() : this.field_178314_g;
    }

    private boolean func_178295_k() {
        return this.field_178315_d != null;
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        return this.field_178316_e;
    }

    public boolean func_178309_b() {
        return this.func_178295_k() ? this.field_178315_d.func_178309_b() : this.field_178322_i;
    }

    public boolean func_178311_c() {
        return this.field_178321_h;
    }

    public boolean func_178303_d() {
        return this.field_178316_e == null || this.field_178315_d != null && this.field_178315_d.func_178303_d();
    }

    private void func_209566_a(Function<ResourceLocation, IUnbakedModel> modelGetter) {
        IUnbakedModel iunbakedmodel;
        if (this.field_178316_e != null && (iunbakedmodel = modelGetter.apply(this.field_178316_e)) != null) {
            if (!(iunbakedmodel instanceof ModelBlock)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            this.field_178315_d = (ModelBlock)iunbakedmodel;
        }
    }

    public List<ItemOverride> func_187966_f() {
        return this.field_187968_k;
    }

    public ItemOverrideList func_209568_a(ModelBlock model, Function<ResourceLocation, IUnbakedModel> modelGetter, Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        return this.field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(model, modelGetter, spriteGetter, this.field_187968_k);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.field_187968_k) {
            set.add(itemoverride.func_188026_a());
        }
        if (this.field_178316_e != null) {
            set.add(this.field_178316_e);
        }
        return set;
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        if (!this.func_178303_d()) {
            LinkedHashSet set = Sets.newLinkedHashSet();
            ModelBlock modelblock = this;
            do {
                set.add(modelblock);
                modelblock.func_209566_a(modelGetter);
                if (!set.contains(modelblock.field_178315_d)) continue;
                field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)modelblock.field_178317_b, (Object)set.stream().map(p_209570_0_ -> p_209570_0_.field_178317_b).collect(Collectors.joining(" -> ")), (Object)modelblock.field_178315_d.field_178317_b);
                modelblock.field_178316_e = ModelBakery.field_177604_a;
                modelblock.func_209566_a(modelGetter);
            } while (!(modelblock = modelblock.field_178315_d).func_178303_d());
        }
        HashSet set1 = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation(this.func_178308_c("particle"))});
        for (BlockPart blockpart : this.func_178298_a()) {
            for (BlockPartFace blockpartface : blockpart.field_178240_c.values()) {
                String s = this.func_178308_c(blockpartface.field_178242_d);
                if (Objects.equals(s, MissingTextureSprite.func_195677_a().func_195668_m().toString())) {
                    missingTextureErrors.add(String.format("%s in %s", blockpartface.field_178242_d, this.field_178317_b));
                }
                set1.add(new ResourceLocation(s));
            }
        }
        this.field_187968_k.forEach(p_209564_4_ -> {
            IUnbakedModel iunbakedmodel = (IUnbakedModel)modelGetter.apply(p_209564_4_.func_188026_a());
            if (!Objects.equals(iunbakedmodel, this)) {
                set1.addAll(iunbakedmodel.func_209559_a(modelGetter, missingTextureErrors));
            }
        });
        if (this.func_178310_f() == ModelBakery.field_177606_o) {
            ItemModelGenerator.field_178398_a.forEach(p_209569_2_ -> set1.add(new ResourceLocation(this.func_178308_c((String)p_209569_2_))));
        }
        return set1;
    }

    public IBakedModel bake(Function<ResourceLocation, IUnbakedModel> modelGetter, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, IModelState rotationIn, boolean uvlock, VertexFormat format) {
        if (!Attributes.moreSpecific((VertexFormat)format, (VertexFormat)Attributes.DEFAULT_BAKED_FORMAT)) {
            throw new IllegalArgumentException("Cannot bake vanilla model to format other than BLOCK");
        }
        return this.bake(this, modelGetter, spriteGetter, rotationIn, uvlock);
    }

    private IBakedModel bake(ModelBlock model, Function<ResourceLocation, IUnbakedModel> modelGetter, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, IModelState rotationIn, boolean uvlock) {
        ModelBlock modelblock = this.func_178310_f();
        if (modelblock == ModelBakery.field_177606_o) {
            return field_209571_g.func_209579_a(spriteGetter, this).bake(model, modelGetter, spriteGetter, rotationIn, uvlock);
        }
        if (modelblock == ModelBakery.field_177616_r) {
            return new BuiltInModel(this.func_181682_g(), this.func_209568_a(model, modelGetter, spriteGetter));
        }
        TextureAtlasSprite textureatlassprite = spriteGetter.apply(new ResourceLocation(this.func_178308_c("particle")));
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, this.func_209568_a(model, modelGetter, spriteGetter)).func_177646_a(textureatlassprite);
        for (BlockPart blockpart : this.func_178298_a()) {
            for (EnumFacing enumfacing : blockpart.field_178240_c.keySet()) {
                BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get((Object)enumfacing);
                TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(new ResourceLocation(this.func_178308_c(blockpartface.field_178242_d)));
                if (blockpartface.field_178244_b == null) {
                    simplebakedmodel$builder.func_177648_a(ModelBlock.makeBakedQuad(blockpart, blockpartface, textureatlassprite1, enumfacing, rotationIn, uvlock));
                    continue;
                }
                simplebakedmodel$builder.func_177650_a(rotationIn.apply(Optional.empty()).map(trsr -> trsr.rotate(enumfacing)).orElse(enumfacing), ModelBlock.makeBakedQuad(blockpart, blockpartface, textureatlassprite1, enumfacing, rotationIn, uvlock));
            }
        }
        return simplebakedmodel$builder.func_177645_b();
    }

    private static BakedQuad func_209567_a(BlockPart part, BlockPartFace partFace, TextureAtlasSprite sprite, EnumFacing face, ModelRotation rotationIn, boolean uvlock) {
        return ModelBlock.makeBakedQuad(part, partFace, sprite, face, rotationIn, uvlock);
    }

    public static BakedQuad makeBakedQuad(BlockPart p_209567_0, BlockPartFace partFace, TextureAtlasSprite sprite, EnumFacing face, IModelState rotationIn, boolean uvlock) {
        return field_209572_h.makeBakedQuad(p_209567_0.field_178241_a, p_209567_0.field_178239_b, partFace, sprite, face, (ITransformation)rotationIn.apply(Optional.empty()).orElse(TRSRTransformation.identity()), p_209567_0.field_178237_d, uvlock, p_209567_0.field_178238_e);
    }

    public boolean func_178300_b(String textureName) {
        return !MissingTextureSprite.func_195677_a().func_195668_m().toString().equals(this.func_178308_c(textureName));
    }

    public String func_178308_c(String textureName) {
        if (!this.func_178304_d(textureName)) {
            textureName = '#' + textureName;
        }
        return this.func_178302_a(textureName, new Bookkeep(this));
    }

    private String func_178302_a(String textureName, Bookkeep p_178302_2_) {
        if (this.func_178304_d(textureName)) {
            if (this == p_178302_2_.field_178323_b) {
                field_178313_f.warn("Unable to resolve texture due to upward reference: {} in {}", (Object)textureName, (Object)this.field_178317_b);
                return MissingTextureSprite.func_195677_a().func_195668_m().toString();
            }
            String s = this.field_178318_c.get(textureName.substring(1));
            if (s == null && this.func_178295_k()) {
                s = this.field_178315_d.func_178302_a(textureName, p_178302_2_);
            }
            p_178302_2_.field_178323_b = this;
            if (s != null && this.func_178304_d(s)) {
                s = p_178302_2_.field_178324_a.func_178302_a(s, p_178302_2_);
            }
            return s != null && !this.func_178304_d(s) ? s : MissingTextureSprite.func_195677_a().func_195668_m().toString();
        }
        return textureName;
    }

    private boolean func_178304_d(String hash) {
        return hash.charAt(0) == '#';
    }

    public ModelBlock func_178310_f() {
        return this.func_178295_k() ? this.field_178315_d.func_178310_f() : this;
    }

    public ItemCameraTransforms func_181682_g() {
        ItemTransformVec3f itemtransformvec3f = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f1 = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f2 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ItemTransformVec3f itemtransformvec3f3 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ItemTransformVec3f itemtransformvec3f4 = this.func_181681_a(ItemCameraTransforms.TransformType.HEAD);
        ItemTransformVec3f itemtransformvec3f5 = this.func_181681_a(ItemCameraTransforms.TransformType.GUI);
        ItemTransformVec3f itemtransformvec3f6 = this.func_181681_a(ItemCameraTransforms.TransformType.GROUND);
        ItemTransformVec3f itemtransformvec3f7 = this.func_181681_a(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(itemtransformvec3f, itemtransformvec3f1, itemtransformvec3f2, itemtransformvec3f3, itemtransformvec3f4, itemtransformvec3f5, itemtransformvec3f6, itemtransformvec3f7);
    }

    private ItemTransformVec3f func_181681_a(ItemCameraTransforms.TransformType type) {
        return this.field_178315_d != null && !this.field_178320_j.func_181687_c(type) ? this.field_178315_d.func_181681_a(type) : this.field_178320_j.func_181688_b(type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ModelBlock> {
        public ModelBlock deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            List<BlockPart> list = this.func_178325_a(p_deserialize_3_, jsonobject);
            String s = this.func_178326_c(jsonobject);
            Map<String, String> map = this.func_178329_b(jsonobject);
            boolean flag = this.func_178328_a(jsonobject);
            ItemCameraTransforms itemcameratransforms = ItemCameraTransforms.field_178357_a;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"display");
                itemcameratransforms = (ItemCameraTransforms)p_deserialize_3_.deserialize((JsonElement)jsonobject1, ItemCameraTransforms.class);
            }
            List<ItemOverride> list1 = this.func_187964_a(p_deserialize_3_, jsonobject);
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            return new ModelBlock(resourcelocation, list, map, flag, true, itemcameratransforms, list1);
        }

        protected List<ItemOverride> func_187964_a(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("overrides")) {
                for (JsonElement jsonelement : JsonUtils.func_151214_t((JsonObject)object, (String)"overrides")) {
                    list.add(deserializationContext.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, String> func_178329_b(JsonObject object) {
            HashMap map = Maps.newHashMap();
            if (object.has("textures")) {
                JsonObject jsonobject = object.getAsJsonObject("textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            return map;
        }

        private String func_178326_c(JsonObject object) {
            return JsonUtils.func_151219_a((JsonObject)object, (String)"parent", (String)"");
        }

        protected boolean func_178328_a(JsonObject object) {
            return JsonUtils.func_151209_a((JsonObject)object, (String)"ambientocclusion", (boolean)true);
        }

        protected List<BlockPart> func_178325_a(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("elements")) {
                for (JsonElement jsonelement : JsonUtils.func_151214_t((JsonObject)object, (String)"elements")) {
                    list.add(deserializationContext.deserialize(jsonelement, BlockPart.class));
                }
            }
            return list;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class Bookkeep {
        public final ModelBlock field_178324_a;
        public ModelBlock field_178323_b;

        private Bookkeep(ModelBlock modelIn) {
            this.field_178324_a = modelIn;
        }
    }
}

