/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Stitcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int field_147971_a;
    private final Set<Holder> field_94319_a = Sets.newHashSetWithExpectedSize((int)256);
    private final List<Slot> field_94317_b = Lists.newArrayListWithCapacity((int)256);
    private int field_94318_c;
    private int field_94315_d;
    private final int field_94316_e;
    private final int field_94313_f;
    private final int field_94323_h;

    public Stitcher(int maxWidthIn, int maxHeightIn, int maxTileDimensionIn, int mipmapLevelStitcherIn) {
        this.field_147971_a = mipmapLevelStitcherIn;
        this.field_94316_e = maxWidthIn;
        this.field_94313_f = maxHeightIn;
        this.field_94323_h = maxTileDimensionIn;
    }

    public int func_110935_a() {
        return this.field_94318_c;
    }

    public int func_110936_b() {
        return this.field_94315_d;
    }

    public void func_110934_a(TextureAtlasSprite textureAtlas) {
        Holder stitcher$holder = new Holder(textureAtlas, this.field_147971_a);
        if (this.field_94323_h > 0) {
            stitcher$holder.func_94196_a(this.field_94323_h);
        }
        this.field_94319_a.add(stitcher$holder);
    }

    public void func_94305_f() {
        Holder[] astitcher$holder = this.field_94319_a.toArray(new Holder[this.field_94319_a.size()]);
        Arrays.sort(astitcher$holder);
        try (ProgressBar bar = StartupProgressManager.start((String)"Texture stitching", (int)astitcher$holder.length);){
            for (Holder stitcher$holder : astitcher$holder) {
                bar.step(stitcher$holder.func_98150_a().func_195668_m().toString());
                if (this.func_94310_b(stitcher$holder)) continue;
                String s = String.format("Unable to fit: %s - size: %dx%d - Maybe try a lowerresolution resourcepack?", stitcher$holder.func_98150_a().func_195668_m(), stitcher$holder.func_98150_a().func_94211_a(), stitcher$holder.func_98150_a().func_94216_b());
                LOGGER.info(s);
                for (Holder h : astitcher$holder) {
                    LOGGER.info("  {}", (Object)h);
                }
                throw new StitcherException(stitcher$holder, s);
            }
            this.field_94318_c = MathHelper.func_151236_b((int)this.field_94318_c);
            this.field_94315_d = MathHelper.func_151236_b((int)this.field_94315_d);
        }
    }

    public List<TextureAtlasSprite> func_94309_g() {
        ArrayList list = Lists.newArrayList();
        for (Slot stitcher$slot : this.field_94317_b) {
            stitcher$slot.func_94184_a(list);
        }
        ArrayList list1 = Lists.newArrayList();
        for (Slot stitcher$slot1 : list) {
            Holder stitcher$holder = stitcher$slot1.func_94183_a();
            TextureAtlasSprite textureatlassprite = stitcher$holder.func_98150_a();
            textureatlassprite.func_110971_a(this.field_94318_c, this.field_94315_d, stitcher$slot1.func_94186_b(), stitcher$slot1.func_94185_c(), stitcher$holder.func_94195_e());
            list1.add(textureatlassprite);
        }
        return list1;
    }

    private static int func_147969_b(int dimensionIn, int mipmapLevelIn) {
        return (dimensionIn >> mipmapLevelIn) + ((dimensionIn & (1 << mipmapLevelIn) - 1) == 0 ? 0 : 1) << mipmapLevelIn;
    }

    private boolean func_94310_b(Holder holderIn) {
        TextureAtlasSprite textureatlassprite = holderIn.func_98150_a();
        boolean flag = textureatlassprite.func_94211_a() != textureatlassprite.func_94216_b();
        for (int i = 0; i < this.field_94317_b.size(); ++i) {
            if (this.field_94317_b.get(i).func_94182_a(holderIn)) {
                return true;
            }
            if (!flag) continue;
            holderIn.func_94194_d();
            if (this.field_94317_b.get(i).func_94182_a(holderIn)) {
                return true;
            }
            holderIn.func_94194_d();
        }
        return this.func_94311_c(holderIn);
    }

    private boolean func_94311_c(Holder holderIn) {
        Slot stitcher$slot;
        boolean flag;
        boolean flag4;
        boolean flag2;
        int i = Math.min(holderIn.func_94197_a(), holderIn.func_94199_b());
        int j = Math.max(holderIn.func_94197_a(), holderIn.func_94199_b());
        int k = MathHelper.func_151236_b((int)this.field_94318_c);
        int l = MathHelper.func_151236_b((int)this.field_94315_d);
        int i1 = MathHelper.func_151236_b((int)(this.field_94318_c + i));
        int j1 = MathHelper.func_151236_b((int)(this.field_94315_d + i));
        boolean flag1 = i1 <= this.field_94316_e;
        boolean bl = flag2 = j1 <= this.field_94313_f;
        if (!flag1 && !flag2) {
            return false;
        }
        boolean flag3 = flag1 && k != i1;
        boolean bl2 = flag4 = flag2 && l != j1;
        if (flag3 ^ flag4) {
            flag = !flag3 && flag1;
        } else {
            boolean bl3 = flag = flag1 && k <= l;
        }
        if (flag) {
            if (holderIn.func_94197_a() > holderIn.func_94199_b()) {
                holderIn.func_94194_d();
            }
            if (this.field_94315_d == 0) {
                this.field_94315_d = holderIn.func_94199_b();
            }
            stitcher$slot = new Slot(this.field_94318_c, 0, holderIn.func_94197_a(), this.field_94315_d);
            this.field_94318_c += holderIn.func_94197_a();
        } else {
            stitcher$slot = new Slot(0, this.field_94315_d, this.field_94318_c, holderIn.func_94199_b());
            this.field_94315_d += holderIn.func_94199_b();
        }
        stitcher$slot.func_94182_a(holderIn);
        this.field_94317_b.add(stitcher$slot);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Slot {
        private final int field_94192_a;
        private final int field_94190_b;
        private final int field_94191_c;
        private final int field_94188_d;
        private List<Slot> field_94189_e;
        private Holder field_94187_f;

        public Slot(int originXIn, int originYIn, int widthIn, int heightIn) {
            this.field_94192_a = originXIn;
            this.field_94190_b = originYIn;
            this.field_94191_c = widthIn;
            this.field_94188_d = heightIn;
        }

        public Holder func_94183_a() {
            return this.field_94187_f;
        }

        public int func_94186_b() {
            return this.field_94192_a;
        }

        public int func_94185_c() {
            return this.field_94190_b;
        }

        public boolean func_94182_a(Holder holderIn) {
            if (this.field_94187_f != null) {
                return false;
            }
            int i = holderIn.func_94197_a();
            int j = holderIn.func_94199_b();
            if (i <= this.field_94191_c && j <= this.field_94188_d) {
                if (i == this.field_94191_c && j == this.field_94188_d) {
                    this.field_94187_f = holderIn;
                    return true;
                }
                if (this.field_94189_e == null) {
                    this.field_94189_e = Lists.newArrayListWithCapacity((int)1);
                    this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b, i, j));
                    int k = this.field_94191_c - i;
                    int l = this.field_94188_d - j;
                    if (l > 0 && k > 0) {
                        int j1;
                        int i1 = Math.max(this.field_94188_d, k);
                        if (i1 >= (j1 = Math.max(this.field_94191_c, l))) {
                            this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b + j, i, l));
                            this.field_94189_e.add(new Slot(this.field_94192_a + i, this.field_94190_b, k, this.field_94188_d));
                        } else {
                            this.field_94189_e.add(new Slot(this.field_94192_a + i, this.field_94190_b, k, j));
                            this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b + j, this.field_94191_c, l));
                        }
                    } else if (k == 0) {
                        this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b + j, i, l));
                    } else if (l == 0) {
                        this.field_94189_e.add(new Slot(this.field_94192_a + i, this.field_94190_b, k, j));
                    }
                }
                for (Slot stitcher$slot : this.field_94189_e) {
                    if (!stitcher$slot.func_94182_a(holderIn)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void func_94184_a(List<Slot> slots) {
            if (this.field_94187_f != null) {
                slots.add(this);
            } else if (this.field_94189_e != null) {
                for (Slot stitcher$slot : this.field_94189_e) {
                    stitcher$slot.func_94184_a(slots);
                }
            }
        }

        public String toString() {
            return "Slot{originX=" + this.field_94192_a + ", originY=" + this.field_94190_b + ", width=" + this.field_94191_c + ", height=" + this.field_94188_d + ", texture=" + this.field_94187_f + ", subSlots=" + this.field_94189_e + '}';
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Holder
    implements Comparable<Holder> {
        private final TextureAtlasSprite field_98151_a;
        private final int field_94204_c;
        private final int field_94201_d;
        private final int field_147968_d;
        private boolean field_94202_e;
        private float field_94205_a = 1.0f;

        public Holder(TextureAtlasSprite theTextureIn, int mipmapLevelHolderIn) {
            this.field_98151_a = theTextureIn;
            this.field_94204_c = theTextureIn.func_94211_a();
            this.field_94201_d = theTextureIn.func_94216_b();
            this.field_147968_d = mipmapLevelHolderIn;
            this.field_94202_e = Stitcher.func_147969_b(this.field_94201_d, mipmapLevelHolderIn) > Stitcher.func_147969_b(this.field_94204_c, mipmapLevelHolderIn);
        }

        public TextureAtlasSprite func_98150_a() {
            return this.field_98151_a;
        }

        public int func_94197_a() {
            int i = this.field_94202_e ? this.field_94201_d : this.field_94204_c;
            return Stitcher.func_147969_b((int)((float)i * this.field_94205_a), this.field_147968_d);
        }

        public int func_94199_b() {
            int i = this.field_94202_e ? this.field_94204_c : this.field_94201_d;
            return Stitcher.func_147969_b((int)((float)i * this.field_94205_a), this.field_147968_d);
        }

        public void func_94194_d() {
            this.field_94202_e = !this.field_94202_e;
        }

        public boolean func_94195_e() {
            return this.field_94202_e;
        }

        public void func_94196_a(int dimensionIn) {
            if (this.field_94204_c > dimensionIn && this.field_94201_d > dimensionIn) {
                this.field_94205_a = (float)dimensionIn / (float)Math.min(this.field_94204_c, this.field_94201_d);
            }
        }

        public String toString() {
            return "Holder{width=" + this.field_94204_c + ", height=" + this.field_94201_d + ", name=" + this.field_98151_a.func_195668_m() + '}';
        }

        @Override
        public int compareTo(Holder p_compareTo_1_) {
            int i;
            if (this.func_94199_b() == p_compareTo_1_.func_94199_b()) {
                if (this.func_94197_a() == p_compareTo_1_.func_94197_a()) {
                    return this.field_98151_a.func_195668_m().toString().compareTo(p_compareTo_1_.field_98151_a.func_195668_m().toString());
                }
                i = this.func_94197_a() < p_compareTo_1_.func_94197_a() ? 1 : -1;
            } else {
                i = this.func_94199_b() < p_compareTo_1_.func_94199_b() ? 1 : -1;
            }
            return i;
        }
    }
}

